"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _field_histograms = require("../../../../common/types/field_histograms");
var _use_column_chart = require("./use_column_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cssHistogram = (0, _react2.css)({
  width: '100%',
  height: `calc(${_uiTheme.euiThemeVars.euiSizeXL} + ${_uiTheme.euiThemeVars.euiSizeXXL})`
});
const cssHistogramLegend = (0, _react2.css)([(0, _react2.css)`
    ${(0, _eui.euiTextTruncate)()}
  `, {
  color: _uiTheme.euiThemeVars.euiColorMediumShade,
  display: 'block',
  overflowX: 'hidden',
  margin: `${_uiTheme.euiThemeVars.euiSizeXS} 0 0 0`,
  fontSize: _uiTheme.euiThemeVars.euiFontSizeXS,
  fontStyle: 'italic',
  fontWeight: 'normal',
  textAlign: 'left'
}]);
const cssHistogramLegendNumeric = (0, _react2.css)([cssHistogramLegend, {
  textAlign: 'right'
}]);
const columnChartTheme = {
  background: {
    color: 'transparent'
  },
  chartMargins: {
    left: 0,
    right: 0,
    top: 0,
    bottom: 1
  },
  chartPaddings: {
    left: 0,
    right: 0,
    top: 0,
    bottom: 0
  },
  scales: {
    barsPadding: 0.1
  }
};
const ColumnChart = ({
  chartData,
  columnType,
  dataTestSubj,
  hideLabel,
  maxChartColumns
}) => {
  const {
    data,
    legendText
  } = (0, _use_column_chart.useColumnChart)(chartData, columnType, maxChartColumns);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, !(0, _field_histograms.isUnsupportedChartData)(chartData) && data.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    css: cssHistogram,
    "data-test-subj": `${dataTestSubj}-histogram`
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
  , {
    theme: columnChartTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "histogram",
    name: "count",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'key_as_string',
    yAccessors: ['doc_count'],
    styleAccessor: d => d.datum.color,
    data: data
  }))), /*#__PURE__*/_react.default.createElement("div", {
    css: columnType.schema === 'number' ? cssHistogramLegendNumeric : cssHistogramLegend,
    "data-test-subj": `${dataTestSubj}-legend`
  }, legendText), !hideLabel && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-id`
  }, columnType.id));
};
exports.ColumnChart = ColumnChart;