"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChartTooltipDefaultState = exports.ChartTooltipService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _operators = require("rxjs/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChartTooltipDefaultState = () => ({
  isTooltipVisible: false,
  tooltipData: [],
  offset: {
    x: 0,
    y: 0
  },
  target: null
});
exports.getChartTooltipDefaultState = getChartTooltipDefaultState;
class ChartTooltipService {
  constructor() {
    (0, _defineProperty2.default)(this, "chartTooltip$", new _rxjs.BehaviorSubject(getChartTooltipDefaultState()));
    (0, _defineProperty2.default)(this, "tooltipState$", this.chartTooltip$.asObservable().pipe((0, _operators.distinctUntilChanged)(_lodash.isEqual)));
  }
  show(tooltipData, target, offset = {
    x: 0,
    y: 0
  }) {
    if (!target) {
      throw new Error('target is required for the tooltip positioning');
    }
    this.chartTooltip$.next({
      ...this.chartTooltip$.getValue(),
      isTooltipVisible: true,
      offset,
      tooltipData,
      target
    });
  }
  hide() {
    this.chartTooltip$.next({
      ...getChartTooltipDefaultState(),
      isTooltipVisible: false
    });
  }
}
exports.ChartTooltipService = ChartTooltipService;