"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMlGlobalServices = getMlGlobalServices;
exports.isServerless = isServerless;
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
require("./_index.scss");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _rxjs = require("rxjs");
var _check_capabilities = require("./capabilities/check_capabilities");
var _storage = require("../../common/types/storage");
var _locator = require("../../common/constants/locator");
var _dependency_cache = require("./util/dependency_cache");
var _license = require("./license");
var _usage_collection = require("./services/usage_collection");
var _routing = require("./routing");
var _ml_api_service = require("./services/ml_api_service");
var _http_service = require("./services/http_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

// temporary function to hardcode the serverless state
// this will be replaced by the true serverless information from kibana
function isServerless() {
  return false;
}

/**
 * Provides global services available across the entire ML app.
 */
function getMlGlobalServices(httpStart, usageCollection) {
  const httpService = new _http_service.HttpService(httpStart);
  return {
    httpService,
    mlApiServices: (0, _ml_api_service.mlApiServicesProvider)(httpService),
    mlUsageCollection: (0, _usage_collection.mlUsageCollectionProvider)(usageCollection),
    isServerless,
    mlCapabilities: _check_capabilities.mlCapabilities
  };
}
const App = ({
  coreStart,
  deps,
  appMountParams
}) => {
  var _deps$usageCollection, _deps$usageCollection2;
  const redirectToMlAccessDeniedPage = async () => {
    // access maybe be denied due to an expired license, so check the license status first
    // if the license has expired, redirect to the license management page
    const license = await (0, _rxjs.firstValueFrom)(deps.licensing.license$);
    const redirectPage = license.status === 'expired' ? deps.share.url.locators.get('LICENSE_MANAGEMENT_LOCATOR').getUrl({
      page: 'dashboard'
    }) : deps.share.url.locators.get(_locator.ML_APP_LOCATOR).getUrl({
      page: _locator.ML_PAGES.ACCESS_DENIED
    });
    await coreStart.application.navigateToUrl(await redirectPage);
  };
  const pageDeps = {
    history: appMountParams.history,
    setHeaderActionMenu: appMountParams.setHeaderActionMenu,
    dataViewsContract: deps.data.dataViews,
    config: coreStart.uiSettings,
    setBreadcrumbs: coreStart.chrome.setBreadcrumbs,
    redirectToMlAccessDeniedPage,
    getSavedSearchDeps: {
      search: deps.data.search,
      savedObjectsClient: coreStart.savedObjects.client
    }
  };
  const services = {
    kibanaVersion: deps.kibanaVersion,
    share: deps.share,
    data: deps.data,
    security: deps.security,
    licenseManagement: deps.licenseManagement,
    storage: localStorage,
    embeddable: deps.embeddable,
    maps: deps.maps,
    triggersActionsUi: deps.triggersActionsUi,
    dataVisualizer: deps.dataVisualizer,
    usageCollection: deps.usageCollection,
    fieldFormats: deps.fieldFormats,
    dashboard: deps.dashboard,
    charts: deps.charts,
    cases: deps.cases,
    unifiedSearch: deps.unifiedSearch,
    licensing: deps.licensing,
    lens: deps.lens,
    savedObjectsManagement: deps.savedObjectsManagement,
    ...coreStart
  };
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings']),
    toMountPoint: _public2.toMountPoint,
    wrapWithTheme: _public2.wrapWithTheme,
    uiSettingsKeys: _common.UI_SETTINGS
  };
  const I18nContext = coreStart.i18n.Context;
  const ApplicationUsageTrackingProvider = (_deps$usageCollection = (_deps$usageCollection2 = deps.usageCollection) === null || _deps$usageCollection2 === void 0 ? void 0 : _deps$usageCollection2.components.ApplicationUsageTrackingProvider) !== null && _deps$usageCollection !== void 0 ? _deps$usageCollection : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: appMountParams.theme$
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...services,
      mlServices: getMlGlobalServices(coreStart.http, deps.usageCollection)
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.ML_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_routing.MlRouter, {
    pageDeps: pageDeps
  })))))));
};
const renderApp = (coreStart, deps, appMountParams) => {
  (0, _dependency_cache.setDependencyCache)({
    timefilter: deps.data.query.timefilter,
    fieldFormats: deps.fieldFormats,
    autocomplete: deps.unifiedSearch.autocomplete,
    config: coreStart.uiSettings,
    chrome: coreStart.chrome,
    docLinks: coreStart.docLinks,
    toastNotifications: coreStart.notifications.toasts,
    overlays: coreStart.overlays,
    theme: coreStart.theme,
    recentlyAccessed: coreStart.chrome.recentlyAccessed,
    basePath: coreStart.http.basePath,
    savedObjectsClient: coreStart.savedObjects.client,
    application: coreStart.application,
    http: coreStart.http,
    security: deps.security,
    dashboard: deps.dashboard,
    maps: deps.maps,
    dataVisualizer: deps.dataVisualizer,
    dataViews: deps.data.dataViews,
    share: deps.share,
    lens: deps.lens
  });
  appMountParams.onAppLeave(actions => actions.default());
  const mlLicense = (0, _license.setLicenseCache)(deps.licensing, coreStart.application, () => _reactDom.default.render( /*#__PURE__*/_react.default.createElement(App, {
    coreStart: coreStart,
    deps: deps,
    appMountParams: appMountParams
  }), appMountParams.element));
  return () => {
    mlLicense.unsubscribe();
    (0, _dependency_cache.clearCache)();
    _reactDom.default.unmountComponentAtNode(appMountParams.element);
    deps.data.search.session.clear();
  };
};
exports.renderApp = renderApp;