"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainLogRateSpikesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/aiops-plugin/public");
var _ml = require("../contexts/ml");
var _kibana = require("../contexts/kibana");
var _help_menu = require("../components/help_menu");
var _technical_preview_badge = require("../components/technical_preview_badge");
var _page_header = require("../components/page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplainLogRateSpikesPage = () => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const context = (0, _ml.useMlContext)();
  const dataView = context.currentDataView;
  const savedSearch = context.selectedSavedSearch;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explainLogRateSpikes.pageHeader",
    defaultMessage: "Explain log rate spikes"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, null)))), dataView && /*#__PURE__*/_react.default.createElement(_public.ExplainLogRateSpikes, {
    dataView: dataView,
    savedSearch: savedSearch,
    appDependencies: (0, _lodash.pick)(services, ['application', 'data', 'executionContext', 'charts', 'fieldFormats', 'http', 'notifications', 'share', 'storage', 'uiSettings', 'unifiedSearch', 'theme', 'lens'])
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: services.docLinks.links.ml.guide
  }));
};
exports.ExplainLogRateSpikesPage = ExplainLogRateSpikesPage;