"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMlAlerts = registerMlAlerts;
exports.registerNavigation = registerNavigation;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _alerts = require("../../common/constants/alerts");
var _app = require("../../common/constants/app");
var _anomaly_detection = require("../locator/formatters/anomaly_detection");
var _validators = require("./validators");
var _jobs_health_rule = require("./jobs_health_rule");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function registerMlAlerts(triggersActionsUi, alerting) {
  triggersActionsUi.ruleTypeRegistry.register({
    id: _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION,
    description: _i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.description', {
      defaultMessage: 'Alert when anomaly detection jobs results match the condition.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return docLinks.links.ml.alertingRules;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./ml_anomaly_alert_trigger')))),
    validate: ruleParams => {
      var _ruleParams$jobSelect, _ruleParams$jobSelect2, _ruleParams$jobSelect3, _ruleParams$jobSelect4, _ruleParams$jobSelect5, _ruleParams$jobSelect6, _ruleParams$jobSelect7, _ruleParams$jobSelect8;
      const validationResult = {
        errors: {
          jobSelection: new Array(),
          severity: new Array(),
          resultType: new Array(),
          topNBuckets: new Array(),
          lookbackInterval: new Array()
        }
      };
      if (!((_ruleParams$jobSelect = ruleParams.jobSelection) !== null && _ruleParams$jobSelect !== void 0 && (_ruleParams$jobSelect2 = _ruleParams$jobSelect.jobIds) !== null && _ruleParams$jobSelect2 !== void 0 && _ruleParams$jobSelect2.length) && !((_ruleParams$jobSelect3 = ruleParams.jobSelection) !== null && _ruleParams$jobSelect3 !== void 0 && (_ruleParams$jobSelect4 = _ruleParams$jobSelect3.groupIds) !== null && _ruleParams$jobSelect4 !== void 0 && _ruleParams$jobSelect4.length)) {
        validationResult.errors.jobSelection.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.jobSelection.errorMessage', {
          defaultMessage: 'Job selection is required'
        }));
      }

      // Since 7.13 we support single job selection only
      if (Array.isArray((_ruleParams$jobSelect5 = ruleParams.jobSelection) === null || _ruleParams$jobSelect5 === void 0 ? void 0 : _ruleParams$jobSelect5.groupIds) && ((_ruleParams$jobSelect6 = ruleParams.jobSelection) === null || _ruleParams$jobSelect6 === void 0 ? void 0 : _ruleParams$jobSelect6.groupIds.length) > 0 || Array.isArray((_ruleParams$jobSelect7 = ruleParams.jobSelection) === null || _ruleParams$jobSelect7 === void 0 ? void 0 : _ruleParams$jobSelect7.jobIds) && ((_ruleParams$jobSelect8 = ruleParams.jobSelection) === null || _ruleParams$jobSelect8 === void 0 ? void 0 : _ruleParams$jobSelect8.jobIds.length) > 1) {
        validationResult.errors.jobSelection.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.singleJobSelection.errorMessage', {
          defaultMessage: 'Only one job per rule is allowed'
        }));
      }
      if (ruleParams.severity === undefined) {
        validationResult.errors.severity.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.severity.errorMessage', {
          defaultMessage: 'Anomaly severity is required'
        }));
      }
      if (ruleParams.resultType === undefined) {
        validationResult.errors.resultType.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.resultType.errorMessage', {
          defaultMessage: 'Result type is required'
        }));
      }
      if (!!ruleParams.lookbackInterval && (0, _validators.validateLookbackInterval)(ruleParams.lookbackInterval)) {
        validationResult.errors.lookbackInterval.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.lookbackInterval.errorMessage', {
          defaultMessage: 'Lookback interval is invalid'
        }));
      }
      if (typeof ruleParams.topNBuckets === 'number' && (0, _validators.validateTopNBucket)(ruleParams.topNBuckets)) {
        validationResult.errors.topNBuckets.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.topNBuckets.errorMessage', {
          defaultMessage: 'Number of buckets is invalid'
        }));
      }
      return validationResult;
    },
    requiresAppContext: false,
    defaultActionMessage: _i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.defaultActionMessage', {
      defaultMessage: `[\\{\\{rule.name\\}\\}] Elastic Stack Machine Learning Alert:
- Job IDs: \\{\\{context.jobIds\\}\\}
- Time: \\{\\{context.timestampIso8601\\}\\}
- Anomaly score: \\{\\{context.score\\}\\}

\\{\\{context.message\\}\\}

\\{\\{#context.topInfluencers.length\\}\\}
  Top influencers:
  \\{\\{#context.topInfluencers\\}\\}
    \\{\\{influencer_field_name\\}\\} = \\{\\{influencer_field_value\\}\\} [\\{\\{score\\}\\}]
  \\{\\{/context.topInfluencers\\}\\}
\\{\\{/context.topInfluencers.length\\}\\}

\\{\\{#context.topRecords.length\\}\\}
  Top records:
  \\{\\{#context.topRecords\\}\\}
    \\{\\{function\\}\\}(\\{\\{field_name\\}\\}) \\{\\{by_field_value\\}\\}\\{\\{over_field_value\\}\\}\\{\\{partition_field_value\\}\\} [\\{\\{score\\}\\}]. Typical: \\{\\{typical\\}\\}, Actual: \\{\\{actual\\}\\}
  \\{\\{/context.topRecords\\}\\}
\\{\\{/context.topRecords.length\\}\\}

\\{\\{! Replace kibanaBaseUrl if not configured in Kibana \\}\\}
[Open in Anomaly Explorer](\\{\\{\\{kibanaBaseUrl\\}\\}\\}\\{\\{\\{context.anomalyExplorerUrl\\}\\}\\})
`
    })
  });
  (0, _jobs_health_rule.registerJobsHealthAlertingRule)(triggersActionsUi, alerting);
  if (alerting) {
    registerNavigation(alerting);
  }
}
function registerNavigation(alerting) {
  alerting.registerNavigation(_app.PLUGIN_ID, _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION, alert => {
    var _alertParams$jobSelec, _alertParams$jobSelec2;
    const alertParams = alert.params;
    const jobIds = [...new Set([...((_alertParams$jobSelec = alertParams.jobSelection.jobIds) !== null && _alertParams$jobSelec !== void 0 ? _alertParams$jobSelec : []), ...((_alertParams$jobSelec2 = alertParams.jobSelection.groupIds) !== null && _alertParams$jobSelec2 !== void 0 ? _alertParams$jobSelec2 : [])])];
    return (0, _anomaly_detection.formatExplorerUrl)('/app/ml', {
      jobIds
    });
  });
}