"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewAlertCondition = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../common");
var _validators = require("../../common/util/validators");
var _util = require("../application/jobs/new_job/common/job_validator/util");
var _alerts = require("../../common/constants/alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertInstancePreview = /*#__PURE__*/_react.default.memo(({
  jobIds,
  timestampIso8601,
  score,
  topInfluencers,
  topRecords
}) => {
  const listItems = [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.jobsLabel', {
      defaultMessage: 'Job IDs:'
    }),
    description: jobIds.join(', ')
  }, {
    title: _i18n.i18n.translate('xpack.ml.previewAlert.timeLabel', {
      defaultMessage: 'Time: '
    }),
    description: timestampIso8601
  }, {
    title: _i18n.i18n.translate('xpack.ml.previewAlert.scoreLabel', {
      defaultMessage: 'Anomaly score:'
    }),
    description: score
  }, ...(topInfluencers && topInfluencers.length > 0 ? [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.topInfluencersLabel', {
      defaultMessage: 'Top influencers:'
    }),
    description: /*#__PURE__*/_react.default.createElement("ul", null, topInfluencers.map(i => /*#__PURE__*/_react.default.createElement("li", {
      key: i.unique_key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      transparentBackground: true
    }, i.influencer_field_name), " =", ' ', i.influencer_field_value, " [", i.score, "]")))
  }] : []), ...(topRecords && topRecords.length > 0 ? [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.topRecordsLabel', {
      defaultMessage: 'Top records:'
    }),
    description: /*#__PURE__*/_react.default.createElement("ul", null, topRecords.map(i => {
      var _i$typical, _i$actual;
      return /*#__PURE__*/_react.default.createElement("li", {
        key: i.unique_key
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        transparentBackground: true
      }, i.function, "(", i.field_name, ")"), ' ', i.by_field_value, " ", i.over_field_value, " ", i.partition_field_value, " [", i.score, "]; (", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.previewAlert.typicalLabel",
        defaultMessage: "Typical:"
      }), ' ', (_i$typical = i.typical) !== null && _i$typical !== void 0 ? _i$typical : '-', ",", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.previewAlert.actualLabel",
        defaultMessage: "Actual:"
      }), ' ', (_i$actual = i.actual) !== null && _i$actual !== void 0 ? _i$actual : '-', ")");
    }))
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: 'row',
    compressed: true,
    listItems: listItems
  });
});
const PreviewAlertCondition = ({
  alertingApiService,
  alertParams
}) => {
  var _alertParams$jobSelec, _alertParams$jobSelec2, _alertParams$jobSelec3, _alertParams$jobSelec4;
  const sampleSize = _alerts.ALERT_PREVIEW_SAMPLE_SIZE;
  const [lookBehindInterval, setLookBehindInterval] = (0, _react.useState)();
  const [lastQueryInterval, setLastQueryInterval] = (0, _react.useState)();
  const [areResultsVisible, setAreResultVisible] = (0, _react.useState)(true);
  const [previewError, setPreviewError] = (0, _react.useState)();
  const [previewResponse, setPreviewResponse] = (0, _react.useState)();
  const validators = (0, _react.useMemo)(() => (0, _common.composeValidators)((0, _validators.requiredValidator)(), (0, _validators.timeIntervalInputValidator)()), []);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const validationErrors = (0, _react.useMemo)(() => validators(lookBehindInterval), [lookBehindInterval]);
  (0, _react.useEffect)(function resetPreview() {
    setPreviewResponse(undefined);
  }, [alertParams]);
  const testCondition = (0, _react.useCallback)(async () => {
    try {
      const response = await alertingApiService.preview({
        alertParams,
        timeRange: lookBehindInterval,
        sampleSize
      });
      setPreviewResponse(response);
      setLastQueryInterval(lookBehindInterval);
      setPreviewError(undefined);
    } catch (e) {
      var _e$body;
      setPreviewResponse(undefined);
      setPreviewError((_e$body = e.body) !== null && _e$body !== void 0 ? _e$body : e);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [alertParams, lookBehindInterval]);
  const sampleHits = (0, _react.useMemo)(() => {
    if (!previewResponse) return;
    return previewResponse.results;
  }, [previewResponse]);
  const isReady = (((_alertParams$jobSelec = alertParams.jobSelection) === null || _alertParams$jobSelec === void 0 ? void 0 : (_alertParams$jobSelec2 = _alertParams$jobSelec.jobIds) === null || _alertParams$jobSelec2 === void 0 ? void 0 : _alertParams$jobSelec2.length) > 0 || ((_alertParams$jobSelec3 = alertParams.jobSelection) === null || _alertParams$jobSelec3 === void 0 ? void 0 : (_alertParams$jobSelec4 = _alertParams$jobSelec3.groupIds) === null || _alertParams$jobSelec4 === void 0 ? void 0 : _alertParams$jobSelec4.length) > 0) && !!alertParams.resultType && alertParams.severity !== undefined && validationErrors === null;
  const isInvalid = lookBehindInterval !== undefined && !!validationErrors;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.previewAlert.intervalLabel",
      defaultMessage: "Check the rule condition with an interval"
    }),
    isInvalid: isInvalid,
    error: (0, _util.invalidTimeIntervalMessage)(lookBehindInterval)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: "15d, 6m",
    value: lookBehindInterval !== null && lookBehindInterval !== void 0 ? lookBehindInterval : '',
    onChange: e => {
      setLookBehindInterval(e.target.value);
    },
    isInvalid: isInvalid,
    "data-test-subj": 'mlAnomalyAlertPreviewInterval'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: testCondition,
    disabled: !isReady,
    "data-test-subj": 'mlAnomalyAlertPreviewButton'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.testButtonLabel",
    defaultMessage: "Test"
  })))), previewError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.previewAlert.previewErrorTitle",
      defaultMessage: "Unable to load the preview"
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, previewError.message))), previewResponse && sampleHits && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    "data-test-subj": 'mlAnomalyAlertPreviewMessage'
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.previewMessage",
    defaultMessage: "Found {alertsCount, plural, one {# anomaly} other {# anomalies}} in the last {interval}.",
    values: {
      alertsCount: previewResponse.count,
      interval: lastQueryInterval
    }
  })))), sampleHits.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: 'primary',
    size: "xs",
    onClick: setAreResultVisible.bind(null, !areResultsVisible)
  }, areResultsVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.hideResultsButtonLabel",
    defaultMessage: "Hide results"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.showResultsButtonLabel",
    defaultMessage: "Show results"
  })))), areResultsVisible && sampleHits.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    "data-test-subj": 'mlAnomalyAlertPreviewCallout'
  }, /*#__PURE__*/_react.default.createElement("ul", null, sampleHits.map((v, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: v.key
    }, /*#__PURE__*/_react.default.createElement(AlertInstancePreview, v), i !== sampleHits.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }) : null);
  })), previewResponse.count > sampleSize ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.otherValuesLabel",
    defaultMessage: "and {count, plural, one {# other} other {# others}}",
    values: {
      count: previewResponse.count - sampleSize
    }
  })))) : null) : null));
};
exports.PreviewAlertCondition = PreviewAlertCondition;