"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAnomalyAlertFlyout = exports.JobListMlAnomalyAlertFlyout = exports.EditAlertRule = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../application/contexts/kibana");
var _alerts = require("../../common/constants/alerts");
var _app = require("../../common/constants/app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Invoke alerting flyout from the ML plugin context.
 * @param initialAlert
 * @param jobIds
 * @param onCloseFlyout
 * @param onSave
 * @constructor
 */
const MlAnomalyAlertFlyout = ({
  initialAlert,
  jobIds,
  onCloseFlyout,
  onSave
}) => {
  const {
    services: {
      triggersActionsUi
    }
  } = (0, _kibana.useMlKibana)();
  const AlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUi) return;
    const commonProps = {
      onClose: () => {
        onCloseFlyout();
      },
      onSave: async () => {
        if (onSave) {
          onSave();
        }
      }
    };
    if (initialAlert) {
      var _initialAlert$ruleTyp;
      return triggersActionsUi.getEditRuleFlyout({
        ...commonProps,
        initialRule: {
          ...initialAlert,
          ruleTypeId: (_initialAlert$ruleTyp = initialAlert.ruleTypeId) !== null && _initialAlert$ruleTyp !== void 0 ? _initialAlert$ruleTyp : initialAlert.alertTypeId
        }
      });
    }
    return triggersActionsUi.getAddRuleFlyout({
      ...commonProps,
      consumer: _app.PLUGIN_ID,
      canChangeTrigger: false,
      ruleTypeId: _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION,
      metadata: {},
      initialValues: {
        params: {
          jobSelection: {
            jobIds
          }
        }
      }
    });
    // deps on id to avoid re-rendering on auto-refresh
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [triggersActionsUi, initialAlert === null || initialAlert === void 0 ? void 0 : initialAlert.id, jobIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, AlertFlyout);
};
exports.MlAnomalyAlertFlyout = MlAnomalyAlertFlyout;
/**
 * Component to wire the Alerting flyout with the Job list view.
 * @param setShowFunction
 * @param unsetShowFunction
 * @constructor
 */
const JobListMlAnomalyAlertFlyout = ({
  setShowFunction,
  unsetShowFunction,
  onSave
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const [jobIds, setJobIds] = (0, _react.useState)();
  const showFlyoutCallback = (0, _react.useCallback)(jobIdsUpdate => {
    setJobIds(jobIdsUpdate);
    setIsVisible(true);
  }, []);
  (0, _react.useEffect)(() => {
    setShowFunction(showFlyoutCallback);
    return () => {
      unsetShowFunction();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return isVisible && jobIds ? /*#__PURE__*/_react.default.createElement(MlAnomalyAlertFlyout, {
    jobIds: jobIds,
    onCloseFlyout: () => setIsVisible(false),
    onSave: () => {
      setIsVisible(false);
      onSave();
    }
  }) : null;
};
exports.JobListMlAnomalyAlertFlyout = JobListMlAnomalyAlertFlyout;
const EditAlertRule = ({
  initialAlert,
  onSave
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: setIsVisible.bind(null, !isVisible)
  }, initialAlert.name), isVisible ? /*#__PURE__*/_react.default.createElement(MlAnomalyAlertFlyout, {
    initialAlert: initialAlert,
    onCloseFlyout: setIsVisible.bind(null, false),
    onSave: () => {
      setIsVisible(false);
      onSave();
    }
  }) : null);
};
exports.EditAlertRule = EditAlertRule;