"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestsSelectionControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _alerts = require("../../../common/util/alerts");
var _alerts2 = require("../../../common/constants/alerts");
var _time_interval_control = require("../time_interval_control");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestsSelectionControl = /*#__PURE__*/_react.default.memo(({
  config,
  onChange,
  errors
}) => {
  const uiConfig = (0, _alerts.getResultJobsHealthRuleConfig)(config);
  const updateCallback = (0, _react.useCallback)(update => {
    onChange({
      ...(config !== null && config !== void 0 ? config : {}),
      ...update
    });
  }, [onChange, config]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors
  }, Object.entries(uiConfig).map(([name, conf], i) => {
    var _HEALTH_CHECK_NAMES$n, _HEALTH_CHECK_NAMES$n2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      key: name,
      title: /*#__PURE__*/_react.default.createElement("h4", null, (_HEALTH_CHECK_NAMES$n = _alerts2.HEALTH_CHECK_NAMES[name]) === null || _HEALTH_CHECK_NAMES$n === void 0 ? void 0 : _HEALTH_CHECK_NAMES$n.name),
      description: (_HEALTH_CHECK_NAMES$n2 = _alerts2.HEALTH_CHECK_NAMES[name]) === null || _HEALTH_CHECK_NAMES$n2 === void 0 ? void 0 : _HEALTH_CHECK_NAMES$n2.description,
      fullWidth: true,
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.enableTestLabel",
        defaultMessage: "Enable"
      }),
      onChange: updateCallback.bind(null, {
        [name]: {
          ...uiConfig[name],
          enabled: !uiConfig[name].enabled
        }
      }),
      checked: uiConfig[name].enabled
    })), name === 'delayedData' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.docsCountLabel",
        defaultMessage: "Number of documents"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.docsCountHint",
          defaultMessage: "The threshold for the amount of missing documents to alert upon."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle"
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: uiConfig.delayedData.docsCount,
      onChange: e => {
        updateCallback({
          [name]: {
            ...uiConfig[name],
            docsCount: Number(e.target.value)
          }
        });
      },
      min: 1
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_time_interval_control.TimeIntervalControl, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.timeIntervalLabel",
        defaultMessage: "Time interval"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.timeIntervalHint",
          defaultMessage: "The lookback interval to check during rule execution for delayed data. By default derived from the longest bucket span and query delay."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle"
      }))),
      value: uiConfig.delayedData.timeInterval,
      onChange: e => {
        updateCallback({
          [name]: {
            ...uiConfig[name],
            timeInterval: e
          }
        });
      }
    })) : null);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
exports.TestsSelectionControl = TestsSelectionControl;