"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelectorControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _alerts = require("../../common/constants/alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSelectorControl = ({
  jobsAndGroupIds,
  onChange,
  adJobsApiService,
  errors,
  multiSelect = false,
  label,
  allowSelectAll = false,
  options: defaultOptions
}) => {
  const [options, setOptions] = (0, _react.useState)([]);
  const jobIds = (0, _react.useMemo)(() => new Set(), []);
  const groupIds = (0, _react.useMemo)(() => new Set(), []);
  const selectedOptions = (0, _react.useMemo)(() => (jobsAndGroupIds !== null && jobsAndGroupIds !== void 0 ? jobsAndGroupIds : []).map(v => ({
    label: v
  })), [jobsAndGroupIds]);
  const fetchOptions = (0, _react.useCallback)(async () => {
    try {
      const {
        jobIds: jobIdOptions,
        groupIds: groupIdOptions
      } = await adJobsApiService.getAllJobAndGroupIds();
      jobIdOptions.forEach(v => {
        jobIds.add(v);
      });
      groupIdOptions.forEach(v => {
        groupIds.add(v);
      });
      setOptions([...(allowSelectAll ? [{
        label: _i18n.i18n.translate('xpack.ml.jobSelector.selectAllGroupLabel', {
          defaultMessage: 'Select all'
        }),
        options: [{
          label: _i18n.i18n.translate('xpack.ml.jobSelector.selectAllOptionLabel', {
            defaultMessage: '*'
          }),
          value: _alerts.ALL_JOBS_SELECTION
        }]
      }] : []), {
        label: _i18n.i18n.translate('xpack.ml.jobSelector.jobOptionsLabel', {
          defaultMessage: 'Jobs'
        }),
        options: jobIdOptions.map(v => ({
          label: v
        }))
      }, ...(multiSelect ? [{
        label: _i18n.i18n.translate('xpack.ml.jobSelector.groupOptionsLabel', {
          defaultMessage: 'Groups'
        }),
        options: groupIdOptions.map(v => ({
          label: v
        }))
      }] : [])]);
    } catch (e) {
      // TODO add error handling
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [adJobsApiService]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const onSelectionChange = (0, _react.useCallback)(selectionUpdate => {
    if (selectionUpdate.some(selectedOption => selectedOption.value === _alerts.ALL_JOBS_SELECTION)) {
      onChange({
        jobIds: [_alerts.ALL_JOBS_SELECTION]
      });
      return;
    }
    const selectedJobIds = [];
    const selectedGroupIds = [];
    selectionUpdate.forEach(({
      label: selectedLabel
    }) => {
      if (jobIds.has(selectedLabel)) {
        selectedJobIds.push(selectedLabel);
      } else if (groupIds.has(selectedLabel)) {
        selectedGroupIds.push(selectedLabel);
      } else if (defaultOptions !== null && defaultOptions !== void 0 && defaultOptions.some(v => {
        var _v$options;
        return (_v$options = v.options) === null || _v$options === void 0 ? void 0 : _v$options.some(o => o.label === selectedLabel);
      })) {
        selectedJobIds.push(selectedLabel);
      }
    });
    onChange({
      ...(selectedJobIds.length > 0 ? {
        jobIds: selectedJobIds
      } : {}),
      ...(selectedGroupIds.length > 0 ? {
        groupIds: selectedGroupIds
      } : {})
    });
  }, [jobIds, groupIds, defaultOptions]);
  (0, _react.useEffect)(() => {
    if (defaultOptions) return;
    fetchOptions();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label !== null && label !== void 0 ? label : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.formControlLabel",
      defaultMessage: "Select job"
    }),
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: !multiSelect,
    selectedOptions: selectedOptions,
    options: defaultOptions !== null && defaultOptions !== void 0 ? defaultOptions : options,
    onChange: onSelectionChange,
    fullWidth: true,
    "data-test-subj": 'mlAnomalyAlertJobSelection',
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length)
  }));
};
exports.JobSelectorControl = JobSelectorControl;