"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKbnFieldIconType = getKbnFieldIconType;
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKbnFieldIconType(type) {
  switch (type) {
    case _fieldTypes.ES_FIELD_TYPES.FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER:
    case _fieldTypes.ES_FIELD_TYPES.LONG:
    case _fieldTypes.ES_FIELD_TYPES.SHORT:
    case _fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG:
      return 'number';
    case _fieldTypes.ES_FIELD_TYPES.DATE:
    case _fieldTypes.ES_FIELD_TYPES.DATE_NANOS:
      return 'date';
    default:
      return type;
  }
}