"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSignificantTerm = isSignificantTerm;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for a significant term.
 * Note this is used as a custom type within Explain Log Rate Spikes
 * for a p-value based variant, not a generic significant terms
 * aggregation type.
 * @param arg The unknown type to be evaluated
 * @returns whether arg is of type SignificantTerm
 */
function isSignificantTerm(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['fieldName', 'fieldValue', 'doc_count', 'bg_count', 'total_doc_count', 'total_bg_count', 'score', 'pValue', 'normalizedScore']);
}