"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeGeoFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../kibana_services");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const visualizeGeoFieldAction = (0, _public.createAction)({
  id: _public.ACTION_VISUALIZE_GEO_FIELD,
  type: _public.ACTION_VISUALIZE_GEO_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.maps.discover.visualizeFieldLabel', {
    defaultMessage: 'Visualize in Maps'
  }),
  isCompatible: async () => !!(0, _kibana_services.getVisualizeCapabilities)().show,
  getHref: async context => {
    const {
      getMapsLink
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./get_maps_link')));
    const {
      app,
      path
    } = await getMapsLink(context);
    return (0, _kibana_services.getCore)().application.getUrlForApp(app, {
      path,
      absolute: false
    });
  },
  execute: async context => {
    const {
      getMapsLink
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./get_maps_link')));
    const {
      app,
      path,
      state
    } = await getMapsLink(context);
    const usageCollection = (0, _kibana_services.getUsageCollection)();
    usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(_constants.APP_ID, _analytics.METRIC_TYPE.CLICK, `create_maps_vis_${context.originatingApp ? context.originatingApp : 'unknownOriginatingApp'}`);
    (0, _kibana_services.getCore)().application.navigateToApp(app, {
      path,
      state
    });
  }
});
exports.visualizeGeoFieldAction = visualizeGeoFieldAction;