"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompatible = isCompatible;
var _constants = require("../../../common/constants");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
var _map_embeddables_singleton = require("../../embeddable/map_embeddables_singleton");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isCompatible({
  embeddable
}) {
  var _getSavedVis;
  if (!_map_embeddables_singleton.mapEmbeddablesSingleton.hasMultipleMaps()) {
    return false;
  }
  if (embeddable.type === 'lens' && typeof embeddable.getSavedVis === 'function' && ((_getSavedVis = embeddable.getSavedVis()) === null || _getSavedVis === void 0 ? void 0 : _getSavedVis.visualizationType) === 'lnsChoropleth') {
    return true;
  }
  if ((0, _is_legacy_map.isLegacyMap)(embeddable)) {
    return true;
  }
  return embeddable.type === _constants.MAP_SAVED_OBJECT_TYPE;
}