"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.synchronizeMovementAction = exports.SYNCHRONIZE_MOVEMENT_ACTION = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const SYNCHRONIZE_MOVEMENT_ACTION = 'SYNCHRONIZE_MOVEMENT_ACTION';
exports.SYNCHRONIZE_MOVEMENT_ACTION = SYNCHRONIZE_MOVEMENT_ACTION;
const synchronizeMovementAction = (0, _public.createAction)({
  id: SYNCHRONIZE_MOVEMENT_ACTION,
  type: SYNCHRONIZE_MOVEMENT_ACTION,
  order: 21,
  getDisplayName: ({
    embeddable
  }) => {
    return _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.title', {
      defaultMessage: 'Synchronize map movement'
    });
  },
  getDisplayNameTooltip: () => {
    return _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.tooltipContent', {
      defaultMessage: 'Synchronize maps, so that if you zoom and pan in one map, the movement is reflected in other maps'
    });
  },
  getIconType: () => {
    return 'crosshairs';
  },
  isCompatible: async context => {
    const {
      isCompatible
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./is_compatible')));
    return isCompatible(context);
  },
  execute: async context => {
    const {
      openModal
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./modal')));
    openModal();
  }
});
exports.synchronizeMovementAction = synchronizeMovementAction;