"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompatible = isCompatible;
var _constants = require("../../../common/constants");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isCompatible({
  embeddable
}) {
  return (embeddable.type === _constants.MAP_SAVED_OBJECT_TYPE || (0, _is_legacy_map.isLegacyMap)(embeddable)) && !embeddable.getInput().disableTriggers;
}