"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterByMapExtentAction = exports.FILTER_BY_MAP_EXTENT = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const FILTER_BY_MAP_EXTENT = 'FILTER_BY_MAP_EXTENT';
exports.FILTER_BY_MAP_EXTENT = FILTER_BY_MAP_EXTENT;
function getContainerLabel(embeddable) {
  var _embeddable$parent;
  return ((_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.type) === 'dashboard' ? _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.dashboardLabel', {
    defaultMessage: 'dashboard'
  }) : _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.pageLabel', {
    defaultMessage: 'page'
  });
}
function getDisplayName(embeddable) {
  return _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayName', {
    defaultMessage: 'Filter {containerLabel} by map bounds',
    values: {
      containerLabel: getContainerLabel(embeddable)
    }
  });
}
const filterByMapExtentAction = (0, _public.createAction)({
  id: FILTER_BY_MAP_EXTENT,
  type: FILTER_BY_MAP_EXTENT,
  order: 20,
  getDisplayName: context => {
    return getDisplayName(context.embeddable);
  },
  getDisplayNameTooltip: context => {
    return _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayNameTooltip', {
      defaultMessage: 'As you zoom and pan the map, the {containerLabel} updates to display only the data visible in the map bounds.',
      values: {
        containerLabel: getContainerLabel(context.embeddable)
      }
    });
  },
  getIconType: () => {
    return 'filter';
  },
  isCompatible: async context => {
    const {
      isCompatible
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./is_compatible')));
    return isCompatible(context);
  },
  execute: async context => {
    const {
      openModal
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./modal')));
    openModal(getDisplayName(context.embeddable));
  }
});
exports.filterByMapExtentAction = filterByMapExtentAction;