"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialRefreshConfig = getInitialRefreshConfig;
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialRefreshConfig({
  serializedMapState,
  globalState = {}
}) {
  const uiSettings = (0, _kibana_services.getUiSettings)();
  if (serializedMapState !== null && serializedMapState !== void 0 && serializedMapState.refreshConfig) {
    return serializedMapState.refreshConfig;
  }
  const defaultRefreshConfig = uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS);
  const refreshInterval = {
    ...defaultRefreshConfig,
    ...globalState.refreshInterval
  };
  return {
    isPaused: refreshInterval.pause,
    interval: refreshInterval.value
  };
}