"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialQuery = getInitialQuery;
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialQuery({
  serializedMapState,
  appState = {}
}) {
  if (appState.query) {
    return appState.query;
  }
  if (serializedMapState !== null && serializedMapState !== void 0 && serializedMapState.query) {
    return serializedMapState.query;
  }
  return (0, _kibana_services.getData)().query.queryString.getDefaultQuery();
}