"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLicenseId = exports.getIsGoldPlus = exports.LICENSED_FEATURES = exports.LICENCED_FEATURES_DETAILS = void 0;
exports.notifyLicensedFeatureUsage = notifyLicensedFeatureUsage;
exports.registerLicensedFeatures = registerLicensedFeatures;
exports.setLicensingPluginStart = setLicensingPluginStart;
exports.whenLicenseInitialized = void 0;
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let LICENSED_FEATURES;
exports.LICENSED_FEATURES = LICENSED_FEATURES;
(function (LICENSED_FEATURES) {
  LICENSED_FEATURES["GEO_LINE_AGG"] = "GEO_LINE_AGG";
  LICENSED_FEATURES["GEO_SHAPE_AGGS_GEO_TILE"] = "GEO_SHAPE_AGGS_GEO_TILE";
  LICENSED_FEATURES["ON_PREM_EMS"] = "ON_PREM_EMS";
})(LICENSED_FEATURES || (exports.LICENSED_FEATURES = LICENSED_FEATURES = {}));
const LICENCED_FEATURES_DETAILS = {
  [LICENSED_FEATURES.GEO_LINE_AGG]: {
    name: 'geo_line aggregation',
    license: 'gold'
  },
  [LICENSED_FEATURES.GEO_SHAPE_AGGS_GEO_TILE]: {
    name: 'geo_tile aggregation on geo_shape field-type',
    license: 'gold'
  },
  [LICENSED_FEATURES.ON_PREM_EMS]: {
    name: 'layer from local Elastic Maps Server',
    license: 'enterprise'
  }
};
exports.LICENCED_FEATURES_DETAILS = LICENCED_FEATURES_DETAILS;
let licenseId;
let isGoldPlus = false;
const getLicenseId = () => licenseId;
exports.getLicenseId = getLicenseId;
const getIsGoldPlus = () => isGoldPlus;
exports.getIsGoldPlus = getIsGoldPlus;
let licensingPluginStart;
let initializeLicense;
const licenseInitialized = new Promise(resolve => {
  initializeLicense = resolve;
});
const whenLicenseInitialized = async () => {
  await licenseInitialized;
};
exports.whenLicenseInitialized = whenLicenseInitialized;
async function setLicensingPluginStart(licensingPlugin) {
  const license = await licensingPlugin.refresh();
  updateLicenseState(license);
  licensingPluginStart = licensingPlugin;
  licensingPluginStart.license$.subscribe(updateLicenseState);
  initializeLicense(undefined);
}
function updateLicenseState(license) {
  const gold = license.check(_constants.APP_ID, 'gold');
  isGoldPlus = gold.state === 'valid';
  licenseId = license.uid;
}
function registerLicensedFeatures(licensingPlugin) {
  for (const licensedFeature of Object.values(LICENSED_FEATURES)) {
    licensingPlugin.featureUsage.register(LICENCED_FEATURES_DETAILS[licensedFeature].name, LICENCED_FEATURES_DETAILS[licensedFeature].license);
  }
}
function notifyLicensedFeatureUsage(licensedFeature) {
  if (!licensingPluginStart) {
    // eslint-disable-next-line no-console
    console.error('May not call notifyLicensedFeatureUsage before plugin start');
    return;
  }
  licensingPluginStart.featureUsage.notifyUsage(LICENCED_FEATURES_DETAILS[LICENSED_FEATURES[licensedFeature]].name);
}