"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RENDERER_ID = void 0;
exports.getExpressionRenderer = getExpressionRenderer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _analytics = require("@kbn/analytics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const RENDERER_ID = 'lens_choropleth_chart_renderer';

/** @internal **/
exports.RENDERER_ID = RENDERER_ID;
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};

/** @internal **/
const extractVisualizationType = context => {
  if (context) {
    var _recursiveGet2;
    const recursiveGet = item => {
      if (item.child) {
        return recursiveGet(item.child);
      } else {
        return item;
      }
    };
    return (_recursiveGet2 = recursiveGet(context)) === null || _recursiveGet2 === void 0 ? void 0 : _recursiveGet2.type;
  }
};
function getExpressionRenderer(coreSetup) {
  return {
    name: RENDERER_ID,
    displayName: 'Choropleth chart',
    help: 'Choropleth chart renderer',
    validate: () => undefined,
    reuseDomNode: true,
    render: async (domNode, config, handlers) => {
      const [coreStart, plugins] = await coreSetup.getStartServices();
      const {
        ChoroplethChart
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./choropleth_chart')));
      const {
        getEmsFileLayers
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../util')));
      const mapEmbeddableFactory = plugins.embeddable.getEmbeddableFactory('map');
      if (!mapEmbeddableFactory) {
        return;
      }
      let emsFileLayers = [];
      try {
        emsFileLayers = await getEmsFileLayers();
      } catch (error) {
        // ignore error, lack of EMS file layers will be surfaced in dimension editor
      }
      const renderComplete = () => {
        const executionContext = handlers.getExecutionContext();
        const containerType = extractContainerType(executionContext);
        const visualizationType = extractVisualizationType(executionContext);
        if (containerType && visualizationType) {
          var _plugins$usageCollect;
          (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_regionmap`]);
        }
        handlers.done();
      };
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(ChoroplethChart, (0, _extends2.default)({}, config, {
        formatFactory: plugins.fieldFormats.deserialize,
        uiSettings: coreStart.uiSettings,
        emsFileLayers: emsFileLayers,
        mapEmbeddableFactory: mapEmbeddableFactory,
        onRenderComplete: renderComplete
      })), domNode);
      handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
    }
  };
}