"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.title = exports.tileMapVisType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _to_ast = require("./to_ast");
var _types = require("./types");
var _lazy_wrapper = require("../../lazy_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const title = _i18n.i18n.translate('xpack.maps.tileMap.vis.title', {
  defaultMessage: 'Coordinate Map'
});
exports.title = title;
const LazyTileMapEditor = function (props) {
  const getLazyComponent = () => {
    return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./tile_map_editor'))));
  };
  return /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
    getLazyComponent: getLazyComponent,
    lazyComponentProps: props
  });
};
const tileMapVisType = {
  name: _types.TILE_MAP_VIS_TYPE,
  title,
  icon: 'visMapCoordinate',
  description: _i18n.i18n.translate('xpack.maps.tileMap.vis.description', {
    defaultMessage: 'Plot latitude and longitude coordinates on a map'
  }),
  editorConfig: {
    optionTabs: [{
      name: '',
      title: '',
      editor: LazyTileMapEditor
    }]
  },
  visConfig: {
    defaults: {
      colorSchema: 'Yellow to Red',
      mapType: _types.MapTypes.ScaledCircleMarkers,
      mapZoom: 2,
      mapCenter: [0, 0]
    }
  },
  toExpressionAst: _to_ast.toExpressionAst,
  requiresSearch: true
};
exports.tileMapVisType = tileMapVisType;