"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorTileInspectorView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lazy_wrapper = require("../../lazy_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getLazyComponent = () => {
  return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/vector_tile_inspector'))));
};
const VectorTileInspectorView = {
  title: _i18n.i18n.translate('xpack.maps.inspector.vectorTileViewTitle', {
    defaultMessage: 'Vector tiles'
  }),
  order: 10,
  help: _i18n.i18n.translate('xpack.maps.inspector.vectorTileViewHelpText', {
    defaultMessage: 'View the vector tile search requests used to collect the data'
  }),
  shouldShow(adapters) {
    return Boolean(adapters.vectorTiles);
  },
  component: props => {
    return /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
      getLazyComponent: getLazyComponent,
      lazyComponentProps: props
    });
  }
};
exports.VectorTileInspectorView = VectorTileInspectorView;