"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ddToMGRS = ddToMGRS;
exports.ddToUTM = ddToUTM;
exports.mgrsToDD = mgrsToDD;
exports.utmToDD = utmToDD;
exports.withinRange = withinRange;
var _i18n = require("@kbn/i18n");
var usng = _interopRequireWildcard(require("usng.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore
const converter = new usng.Converter();
function withinRange(value, min, max) {
  const isInvalid = value === '' || value > max || value < min;
  const error = isInvalid ? _i18n.i18n.translate('xpack.maps.setViewControl.outOfRangeErrorMsg', {
    defaultMessage: `Must be between {min} and {max}`,
    values: {
      min,
      max
    }
  }) : null;
  return {
    isInvalid,
    error
  };
}
function ddToUTM(lat, lon) {
  try {
    const utm = converter.LLtoUTM(lat, lon);
    return {
      northing: utm === converter.UNDEFINED_STR ? '' : String(Math.round(utm.northing)),
      easting: utm === converter.UNDEFINED_STR ? '' : String(Math.round(utm.easting)),
      zone: utm === converter.UNDEFINED_STR ? '' : `${utm.zoneNumber}${converter.UTMLetterDesignator(lat)}`
    };
  } catch (e) {
    return {
      northing: '',
      easting: '',
      zone: ''
    };
  }
}
function utmToDD(northing, easting, zoneNumber) {
  try {
    return converter.UTMtoLL(northing, easting, zoneNumber);
  } catch (e) {
    return undefined;
  }
}
function ddToMGRS(lat, lon) {
  try {
    const mgrsCoord = converter.LLtoMGRS(lat, lon, 5);
    return mgrsCoord;
  } catch (e) {
    return '';
  }
}
function mgrstoUSNG(mgrs) {
  let squareIdEastSpace = 0;
  for (let i = mgrs.length - 1; i > -1; i--) {
    // check if we have hit letters yet
    if (isNaN(parseInt(mgrs.substr(i, 1), 10))) {
      squareIdEastSpace = i + 1;
      break;
    }
  }
  const gridZoneSquareIdSpace = squareIdEastSpace ? squareIdEastSpace - 2 : -1;
  const numPartLength = mgrs.substr(squareIdEastSpace).length / 2;
  // add the number split space
  const eastNorthSpace = squareIdEastSpace ? squareIdEastSpace + numPartLength : -1;
  const stringArray = mgrs.split('');
  stringArray.splice(eastNorthSpace, 0, ' ');
  stringArray.splice(squareIdEastSpace, 0, ' ');
  stringArray.splice(gridZoneSquareIdSpace, 0, ' ');
  const rejoinedArray = stringArray.join('');
  return rejoinedArray;
}
function mgrsToDD(mgrs) {
  try {
    return converter.USNGtoLL(mgrstoUSNG(mgrs));
  } catch (e) {
    return undefined;
  }
}