"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeslider = void 0;
var _reactRedux = require("react-redux");
var _timeslider = require("./timeslider");
var _actions = require("../../actions");
var _map_selectors = require("../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    timeRange: (0, _map_selectors.getTimeFilters)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    setTimeslice: timeslice => {
      dispatch((0, _actions.setQuery)({
        forceRefresh: false,
        timeslice
      }));
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_timeslider.Timeslider);
exports.Timeslider = connected;