"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntryButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _layer_group = require("../../../../../../classes/layers/layer_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TOCEntryButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isFilteredByGlobalTime: false
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadIsFilteredByGlobalTime();
  }
  componentDidUpdate() {
    this._loadIsFilteredByGlobalTime();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadIsFilteredByGlobalTime() {
    const isFilteredByGlobalTime = await this.props.layer.isFilteredByGlobalTime();
    if (this._isMounted && isFilteredByGlobalTime !== this.state.isFilteredByGlobalTime) {
      this.setState({
        isFilteredByGlobalTime
      });
    }
  }
  getIconAndTooltipContent() {
    if (this.props.layer.hasErrors()) {
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "aria-label": _i18n.i18n.translate('xpack.maps.layer.loadWarningAriaLabel', {
            defaultMessage: 'Load warning'
          }),
          size: "m",
          type: "warning",
          color: "warning"
        }),
        tooltipContent: this.props.layer.getErrors(),
        footnotes: []
      };
    }
    if (!this.props.layer.isVisible()) {
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: "eyeClosed"
        }),
        tooltipContent: _i18n.i18n.translate('xpack.maps.layer.layerHiddenTooltip', {
          defaultMessage: `Layer is hidden.`
        }),
        footnotes: []
      };
    }
    if (!this.props.layer.showAtZoomLevel(this.props.zoom)) {
      const minZoom = this.props.layer.getMinZoom();
      const maxZoom = this.props.layer.getMaxZoom();
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: "expand"
        }),
        tooltipContent: _i18n.i18n.translate('xpack.maps.layer.zoomFeedbackTooltip', {
          defaultMessage: `Layer is visible between zoom levels {minZoom} and {maxZoom}.`,
          values: {
            minZoom,
            maxZoom
          }
        }),
        footnotes: []
      };
    }
    if (this.props.layer.isLayerLoading(this.props.zoom)) {
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m"
        }),
        tooltipContent: '',
        footnotes: []
      };
    }
    const {
      icon,
      tooltipContent
    } = this.props.layer.getLayerIcon(true);
    if ((0, _layer_group.isLayerGroup)(this.props.layer)) {
      return {
        icon,
        tooltipContent,
        footnotes: []
      };
    }
    const footnotes = [];
    if (this.props.isUsingSearch && this.props.layer.getQueryableIndexPatternIds().length) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "filter",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingSearchMsg', {
          defaultMessage: 'Results narrowed by global search'
        })
      });
    }
    if (this.state.isFilteredByGlobalTime) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "clock",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingTimeFilter', {
          defaultMessage: 'Results narrowed by global time'
        })
      });
    }
    const source = this.props.layer.getSource();
    if (typeof source.isFilterByMapBounds === 'function' && source.isFilterByMapBounds()) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "stop",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingBoundsFilter', {
          defaultMessage: 'Results narrowed by visible map area'
        })
      });
    }
    return {
      icon,
      tooltipContent,
      footnotes
    };
  }
  render() {
    const {
      icon,
      tooltipContent,
      footnotes
    } = this.getIconAndTooltipContent();
    const footnoteIcons = footnotes.map((footnote, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index
      }, '', footnote.icon);
    });
    const footnoteTooltipContent = footnotes.map((footnote, index) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: index
      }, footnote.icon, " ", footnote.message);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "mapLayTocActions__tooltipAnchor",
      position: "top",
      title: this.props.displayName,
      content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, tooltipContent, footnoteTooltipContent),
      "data-test-subj": "layerTocTooltip"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: "mapTocEntry__layerName eui-textLeft",
      size: "xs",
      flush: "left",
      color: "text",
      onClick: this.props.onClick,
      "data-test-subj": `layerTocActionsPanelToggleButton${this.props.escapedDisplayName}`
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "mapTocEntry__layerNameIcon"
    }, icon), this.props.displayName, " ", footnoteIcons));
  }
}
exports.TOCEntryButton = TOCEntryButton;