"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerControl = LayerControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _layer_toc = require("./layer_toc");
var _kibana_services = require("../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderExpandButton({
  hasErrors,
  isLoading,
  onClick
}) {
  const expandLabel = _i18n.i18n.translate('xpack.maps.layerControl.openLayerTOCButtonAriaLabel', {
    defaultMessage: 'Expand layers panel'
  });
  if (isLoading) {
    // Can not use EuiButtonIcon with spinner because spinner is a class and not an icon
    return /*#__PURE__*/_react.default.createElement("button", {
      className: "euiButtonIcon euiButtonIcon--text mapLayerControl__openLayerTOCButton",
      type: "button",
      onClick: onClick,
      "aria-label": expandLabel,
      "data-test-subj": "mapExpandLayerControlButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "mapLayerControl__openLayerTOCButton",
    color: "text",
    onClick: onClick,
    iconType: hasErrors ? 'warning' : 'menuLeft',
    "aria-label": expandLabel,
    "data-test-subj": "mapExpandLayerControlButton"
  });
}
function LayerControl({
  isReadOnly,
  isLayerTOCOpen,
  showAddLayerWizard,
  closeLayerTOC,
  openLayerTOC,
  layerList,
  isFlyoutOpen,
  hideAllLayers,
  showAllLayers,
  zoom
}) {
  if (!isLayerTOCOpen) {
    if ((0, _kibana_services.isScreenshotMode)()) {
      return null;
    }
    const hasErrors = layerList.some(layer => {
      return layer.hasErrors();
    });
    const isLoading = layerList.some(layer => {
      return layer.isLayerLoading(zoom);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      delay: "long",
      content: _i18n.i18n.translate('xpack.maps.layerControl.openLayerTOCButtonAriaLabel', {
        defaultMessage: 'Expand layers panel'
      }),
      position: "left"
    }, renderExpandButton({
      hasErrors,
      isLoading,
      onClick: openLayerTOC
    }));
  }
  let addLayer;
  if (!isReadOnly) {
    addLayer = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isFlyoutOpen,
      className: "mapLayerControl__addLayerButton",
      fill: true,
      fullWidth: true,
      onClick: showAddLayerWizard,
      "data-test-subj": "addLayerButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerControl.addLayerButtonLabel",
      defaultMessage: "Add layer"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "mapWidgetControl mapWidgetControl-hasShadow",
    paddingSize: "none",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mapWidgetControl__headerFlexItem",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    className: "mapWidgetControl__header"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerControl.layersTitle",
    defaultMessage: "Layers"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.hideAllLayersButton', {
      defaultMessage: 'Hide all layers'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: hideAllLayers,
    iconType: "eyeClosed",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.hideAllLayersButton', {
      defaultMessage: 'Hide all layers'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.showAllLayersButton', {
      defaultMessage: 'Show all layers'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: showAllLayers,
    iconType: "eye",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.showAllLayersButton', {
      defaultMessage: 'Show all layers'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.closeLayerTOCButtonAriaLabel', {
      defaultMessage: 'Collapse layers panel'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "mapLayerControl__closeLayerTOCButton",
    onClick: closeLayerTOC,
    iconType: "menuRight",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.closeLayerTOCButtonAriaLabel', {
      defaultMessage: 'Collapse layers panel'
    }),
    "data-test-subj": "mapToggleLegendButton"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mapLayerControl"
  }, /*#__PURE__*/_react.default.createElement(_layer_toc.LayerTOC, null))), addLayer);
}