"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Header extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      layerIcon: null,
      layerName: null
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLayerState();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLayerState() {
    const layer = this.props.findLayerById(this.props.layerId);
    if (!layer) {
      return;
    }
    const layerName = await layer.getDisplayName();
    const {
      icon
    } = layer.getLayerIcon(false);
    if (this._isMounted) {
      this.setState({
        layerIcon: icon,
        layerName
      });
    }
  }
  render() {
    const items = [];
    if (this.state.layerIcon) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: "layerIcon",
        className: "mapFeatureTooltip_layerIcon"
      }, this.state.layerIcon));
    }
    if (this.state.layerName) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        key: "layerName",
        className: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, null, /*#__PURE__*/_react.default.createElement("h4", {
        className: "eui-textTruncate",
        title: this.state.layerName
      }, this.state.layerName))));
    }
    if (this.props.isLocked) {
      // When close button is the only item, add empty FlexItem to push close button to right
      if (items.length === 0) {
        items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: "spacer"
        }));
      }
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: "closeButton"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: this.props.onClose,
        iconType: "cross",
        "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.closeAriaLabel', {
          defaultMessage: 'Close tooltip'
        }),
        "data-test-subj": "mapTooltipCloseButton"
      })));
    }
    return items.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, items), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    })) : null;
  }
}
exports.Header = Header;