"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesTooltip = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _feature_properties = require("./feature_properties");
var _footer = require("./footer");
var _header = require("./header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROPERTIES_VIEW = 'PROPERTIES_VIEW';
const FILTER_ACTIONS_VIEW = 'FILTER_ACTIONS_VIEW';
class FeaturesTooltip extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      currentFeature: null,
      filterView: null,
      prevFeatures: [],
      view: PROPERTIES_VIEW
    });
    (0, _defineProperty2.default)(this, "_setCurrentFeature", feature => {
      this.setState({
        currentFeature: feature
      });
    });
    (0, _defineProperty2.default)(this, "_showPropertiesView", () => {
      this.setState({
        view: PROPERTIES_VIEW,
        filterView: null
      });
    });
    (0, _defineProperty2.default)(this, "_showFilterActionsView", filterView => {
      this.setState({
        view: FILTER_ACTIONS_VIEW,
        filterView
      });
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.features !== prevState.prevFeatures) {
      let nextCurrentFeature = nextProps.features ? nextProps.features[0] : null;
      if (prevState.currentFeature) {
        const updatedCurrentFeature = nextProps.features.find(tooltipFeature => {
          return tooltipFeature.id === prevState.currentFeature.id && tooltipFeature.layerId === prevState.currentFeature.layerId;
        });
        if (updatedCurrentFeature) {
          nextCurrentFeature = updatedCurrentFeature;
        }
      }
      return {
        currentFeature: nextCurrentFeature,
        view: PROPERTIES_VIEW,
        prevFeatures: nextProps.features
      };
    }
    return null;
  }
  _renderActions() {
    if (!this.props.isLocked || !this.state.currentFeature || this.state.currentFeature.actions.length === 0) {
      return null;
    }
    return this.state.currentFeature.actions.map(action => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        className: "mapFeatureTooltip_actionLinks",
        onClick: () => {
          if (action.onClick) {
            action.onClick();
          } else if (action.form) {
            this.setState({
              view: action.id
            });
          }
        },
        key: action.id
      }, action.label);
    });
  }
  _renderBackButton(label) {
    return /*#__PURE__*/_react.default.createElement("button", {
      className: "euiContextMenuPanelTitle mapFeatureTooltip_backButton",
      type: "button",
      onClick: this._showPropertiesView
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "euiContextMenu__itemLayout"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowLeft",
      size: "m",
      className: "euiContextMenu__icon"
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: "euiContextMenu__text"
    }, label)));
  }
  render() {
    if (!this.state.currentFeature) {
      return null;
    }
    const action = this.state.currentFeature.actions.find(({
      id
    }) => {
      return id === this.state.view;
    });
    if (action && action.form) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderBackButton(action.label), action.form);
    }
    if (this.state.view === FILTER_ACTIONS_VIEW) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderBackButton(_i18n.i18n.translate('xpack.maps.tooltip.showAddFilterActionsViewLabel', {
        defaultMessage: 'Filter actions'
      })), this.state.filterView);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
      key: this.state.currentFeature.layerId,
      layerId: this.state.currentFeature.layerId,
      findLayerById: this.props.findLayerById,
      isLocked: this.props.isLocked,
      onClose: this.props.closeTooltip
    }), /*#__PURE__*/_react.default.createElement(_feature_properties.FeatureProperties, {
      featureId: this.state.currentFeature.id,
      layerId: this.state.currentFeature.layerId,
      mbProperties: this.state.currentFeature.mbProperties,
      loadFeatureProperties: this.props.loadFeatureProperties,
      showFilterButtons: !!this.props.addFilters && this.props.isLocked,
      onCloseTooltip: this.props.closeTooltip,
      addFilters: this.props.addFilters,
      getFilterActions: this.props.getFilterActions,
      getActionContext: this.props.getActionContext,
      onSingleValueTrigger: this.props.onSingleValueTrigger,
      showFilterActions: this._showFilterActionsView
    }), this._renderActions(), /*#__PURE__*/_react.default.createElement(_footer.Footer, {
      features: this.props.features,
      isLocked: this.props.isLocked,
      findLayerById: this.props.findLayerById,
      setCurrentFeature: this._setCurrentFeature
    }));
  }
}
exports.FeaturesTooltip = FeaturesTooltip;