"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCanAccessEmsFonts = getCanAccessEmsFonts;
exports.getGlyphs = getGlyphs;
exports.getKibanaFontsGlyphUrl = getKibanaFontsGlyphUrl;
exports.testOnlyClearCanAccessEmsFontsPromise = testOnlyClearCanAccessEmsFontsPromise;
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let canAccessEmsFonts;
let canAccessEmsFontsPromise = null;
async function getCanAccessEmsFonts() {
  if (!canAccessEmsFontsPromise) {
    canAccessEmsFontsPromise = new Promise(async resolve => {
      try {
        canAccessEmsFonts = undefined;
        const emsSettings = (0, _kibana_services.getEMSSettings)();
        if (!emsSettings || !emsSettings.isEMSEnabled()) {
          resolve(false);
        }
        const emsFontUrlTemplate = emsSettings.getEMSFontLibraryUrl();
        const emsFontUrl = emsFontUrlTemplate.replace('{fontstack}', 'Open Sans').replace('{range}', '0-255');
        const resp = await (0, _nodeFetch.default)(emsFontUrl, {
          method: 'HEAD'
        });
        if (resp.status >= 400) {
          throw new Error(`status: ${resp.status}`);
        }
        canAccessEmsFonts = true;
        resolve(true);
      } catch (error) {
        // eslint-disable-next-line no-console
        console.warn(`Unable to access fonts from Elastic Maps Service (EMS). To avoid unnecessary EMS requests, set 'map.includeElasticMapsService: false' in 'kibana.yml'. For more details please visit: ${(0, _kibana_services.getDocLinks)().links.maps.connectToEms}`);
        canAccessEmsFonts = false;
        resolve(false);
      }
    });
  }
  return canAccessEmsFontsPromise;
}

// test only function to reset singleton for different test cases.
function testOnlyClearCanAccessEmsFontsPromise() {
  canAccessEmsFontsPromise = null;
  canAccessEmsFonts = undefined;
}
function getKibanaFontsGlyphUrl() {
  return (0, _kibana_services.getHttp)().basePath.prepend(`/${_constants.FONTS_API_PATH}/{fontstack}/{range}`);
}
function getGlyphs() {
  const emsSettings = (0, _kibana_services.getEMSSettings)();
  if (!emsSettings || !emsSettings.isEMSEnabled() || typeof canAccessEmsFonts === 'boolean' && !canAccessEmsFonts) {
    return {
      glyphUrlTemplate: getKibanaFontsGlyphUrl(),
      isEmsFont: false
    };
  }
  return {
    glyphUrlTemplate: emsSettings.getEMSFontLibraryUrl(),
    isEmsFont: true
  };
}