"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhereExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WhereExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onQueryChange", ({
      query
    }) => {
      this.props.onChange(query);
      this._closePopover();
    });
  }
  render() {
    const SearchBar = (0, _kibana_services.getSearchBar)();
    const {
      whereQuery,
      indexPattern
    } = this.props;
    const expressionValue = whereQuery && whereQuery.query ? whereQuery.query : _i18n.i18n.translate('xpack.maps.layerPanel.whereExpression.expressionValuePlaceholder', {
      defaultMessage: '-- add filter --'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "whereClausePopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        onClick: this._togglePopover,
        description: _i18n.i18n.translate('xpack.maps.layerPanel.whereExpression.expressionDescription', {
          defaultMessage: 'where'
        }),
        uppercase: false,
        value: expressionValue,
        "data-test-subj": "mapJoinWhereExpressionButton"
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapFilterEditor",
      "data-test-subj": "mapJoinWhereFilterEditor"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      className: "mapJoinExpressionHelpText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.whereExpression.helpText",
      defaultMessage: "Use a query to narrow right source."
    })), /*#__PURE__*/_react.default.createElement(SearchBar, {
      appName: _constants.APP_ID,
      showFilterBar: false,
      showDatePicker: false,
      showQueryInput: true,
      query: whereQuery ? whereQuery : (0, _kibana_services.getData)().query.queryString.getDefaultQuery(),
      onQuerySubmit: this._onQueryChange,
      indexPatterns: [indexPattern],
      customSubmitButton: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "mapWhereFilterEditorSubmitButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.whereExpression.queryBarSubmitButtonLabel",
        defaultMessage: "Set filter"
      }))
    })));
  }
}
exports.WhereExpression = WhereExpression;