"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _metrics_editor = require("../../../../components/metrics_editor");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_renderMetricsEditor", () => {
      if (!this.props.rightFields) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.maps.layerPanel.metricsExpression.joinMustBeSetErrorMessage",
          defaultMessage: "JOIN must be set"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_metrics_editor.MetricsEditor, {
        fields: this.props.rightFields,
        metrics: this.props.metrics,
        onChange: this.props.onChange,
        allowMultipleMetrics: true,
        isJoin: true
      });
    });
  }
  render() {
    const metricExpressions = this.props.metrics.filter(metric => {
      if (metric.type === _constants.AGG_TYPE.COUNT) {
        return true;
      }
      if (metric.field) {
        return true;
      }
      return false;
    }).map(metric => {
      // do not use metric label so field and aggregation are not obscured.
      if (metric.type === _constants.AGG_TYPE.COUNT) {
        return _constants.AGG_TYPE.COUNT;
      }
      return `${metric.type} ${metric.field}`;
    });
    const useMetricDescription = _i18n.i18n.translate('xpack.maps.layerPanel.metricsExpression.useMetricsDescription', {
      defaultMessage: '{metricsLength, plural, one {and use metric} other {and use metrics}}',
      values: {
        metricsLength: metricExpressions.length
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "metricsPopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      initialFocus: "body" /* avoid initialFocus on Combobox */,
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        onClick: this._togglePopover,
        description: useMetricDescription,
        uppercase: false,
        value: metricExpressions.length > 0 ? metricExpressions.join(', ') : _constants.AGG_TYPE.COUNT
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 400
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.metricsExpression.metricsPopoverTitle",
      defaultMessage: "Metrics"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      className: "mapJoinExpressionHelpText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.metricsExpression.helpText",
      defaultMessage: "Configure the metrics for the right source. These values are added to the layer features."
    })), this._renderMetricsEditor()));
  }
}
exports.MetricsExpression = MetricsExpression;