"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _constants = require("../../../../../common/constants");
var _single_field_select = require("../../../../components/single_field_select");
var _validated_number_input = require("../../../../components/validated_number_input");
var _index_pattern_util = require("../../../../index_pattern_util");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JoinExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onRightSourceChange", indexPatternId => {
      if (!indexPatternId || indexPatternId.length === 0) {
        return;
      }
      this.props.onRightSourceChange(indexPatternId);
    });
    (0, _defineProperty2.default)(this, "_onLeftFieldChange", selectedFields => {
      this.props.onLeftFieldChange(_lodash.default.get(selectedFields, '[0].value.name', null));
    });
    (0, _defineProperty2.default)(this, "_onRightFieldChange", term => {
      if (!term || term.length === 0) {
        return;
      }
      this.props.onRightFieldChange(term);
    });
  }
  _renderLeftFieldSelect() {
    const {
      leftValue,
      leftFields
    } = this.props;
    if (!leftFields) {
      return null;
    }
    const options = leftFields.map(field => {
      return {
        value: field,
        label: field.label
      };
    });
    let leftFieldOption;
    if (leftValue) {
      leftFieldOption = options.find(option => {
        const field = option.value;
        return field.name === leftValue;
      });
    }
    const selectedOptions = leftFieldOption ? [leftFieldOption] : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.leftFieldLabel', {
        defaultMessage: 'Left field'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.leftSourceLabelHelpText', {
        defaultMessage: 'Left source field that contains the shared key.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: getSelectFieldPlaceholder(),
      singleSelection: true,
      isClearable: false,
      options: options,
      selectedOptions: selectedOptions,
      onChange: this._onLeftFieldChange
    }));
  }
  _renderRightSourceSelect() {
    if (!this.props.leftValue) {
      return null;
    }
    const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.rightSourceLabel', {
        defaultMessage: 'Right source'
      })
    }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
      placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
      indexPatternId: this.props.rightSourceIndexPatternId,
      onChange: this._onRightSourceChange,
      isClearable: false
    }));
  }
  _renderRightFieldSelect() {
    if (!this.props.rightFields || !this.props.leftValue) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.rightFieldLabel', {
        defaultMessage: 'Right field'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.rightSourceLabelHelpText', {
        defaultMessage: 'Right source field that contains the shared key.'
      })
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: getSelectFieldPlaceholder(),
      value: this.props.rightValue,
      onChange: this._onRightFieldChange,
      fields: (0, _index_pattern_util.getTermsFields)(this.props.rightFields),
      isClearable: false
    }));
  }
  _renderRightFieldSizeInput() {
    if (!this.props.rightValue || !this.props.leftValue) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_validated_number_input.ValidatedNumberInput, {
      initialValue: this.props.rightSize !== undefined ? this.props.rightSize : _constants.DEFAULT_MAX_BUCKETS_LIMIT,
      min: 1,
      max: _constants.DEFAULT_MAX_BUCKETS_LIMIT,
      onChange: this.props.onRightSizeChange,
      label: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.rightSizeLabel', {
        defaultMessage: 'Right size'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.rightSizeHelpText', {
        defaultMessage: 'Right field term limit.'
      })
    });
  }
  _getExpressionValue() {
    const {
      leftSourceName,
      leftValue,
      rightSourceName,
      rightValue,
      rightSize
    } = this.props;
    if (leftSourceName && leftValue && rightSourceName && rightValue) {
      return _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.value', {
        defaultMessage: '{leftSourceName}:{leftValue} with {sizeFragment} {rightSourceName}:{rightValue}',
        values: {
          leftSourceName,
          leftValue,
          sizeFragment: rightSize !== undefined ? _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.sizeFragment', {
            defaultMessage: 'top {rightSize} terms from',
            values: {
              rightSize
            }
          }) : '',
          rightSourceName,
          rightValue
        }
      });
    }
    return _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.selectPlaceholder', {
      defaultMessage: '-- select --'
    });
  }
  render() {
    const {
      leftSourceName
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "joinPopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      initialFocus: "body" /* avoid initialFocus on Combobox */,
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        onClick: this._togglePopover,
        description: "Join",
        uppercase: false,
        value: this._getExpressionValue()
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.joinExpression.joinPopoverTitle",
      defaultMessage: "Join"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      className: "mapJoinExpressionHelpText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.joinExpression.helpText",
      defaultMessage: "Configure the shared key."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.leftSourceLabel', {
        defaultMessage: 'Left source'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      selectedOptions: leftSourceName ? [{
        value: leftSourceName,
        label: leftSourceName
      }] : [],
      isDisabled: true
    })), this._renderLeftFieldSelect(), this._renderRightSourceSelect(), this._renderRightFieldSelect(), this._renderRightFieldSizeInput()));
  }
}
exports.JoinExpression = JoinExpression;
function getSelectFieldPlaceholder() {
  return _i18n.i18n.translate('xpack.maps.layerPanel.joinExpression.selectFieldPlaceholder', {
    defaultMessage: 'Select field'
  });
}