"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinDocumentationPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JoinDocumentationPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _renderContent() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        maxWidth: '36em'
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.intro",
      defaultMessage: "Term joins augment layers with properties for data driven styling. Term joins work as follows:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.sharedKey",
      defaultMessage: "A shared key combines vector features, the left source, with the results of an Elasticsearch aggregation, the right source."
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.termsAggregation",
      defaultMessage: "The terms aggregation creates a bucket for each unique shared key."
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.metrics",
      defaultMessage: "Metrics are calculated for all documents in a bucket."
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.join",
      defaultMessage: "The join adds metrics for each terms aggregation bucket with the corresponding shared key."
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.noMatches",
      defaultMessage: "Features that do have have a corresponding terms aggregation bucket are not visible on the map."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getDocLinks)().links.maps.termJoinsExample,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.joinDocs.linkLabel",
      defaultMessage: "Term join example"
    }))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "joinHelpPopover",
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: this._togglePopover,
        iconType: "documentation",
        "aria-label": "Join documentation"
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      repositionOnScroll: true,
      ownFocus: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.joinEditor.termJoinsTitle",
      defaultMessage: "Term joins"
    })), this._renderContent());
  }
}
exports.JoinDocumentationPopover = JoinDocumentationPopover;