"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Join = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _join_expression = require("./join_expression");
var _metrics_expression = require("./metrics_expression");
var _where_expression = require("./where_expression");
var _global_filter_checkbox = require("../../../../components/global_filter_checkbox");
var _global_time_checkbox = require("../../../../components/global_time_checkbox");
var _kibana_services = require("../../../../kibana_services");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Join extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      rightFields: [],
      indexPattern: undefined,
      loadError: undefined
    });
    (0, _defineProperty2.default)(this, "_onLeftFieldChange", leftField => {
      this.props.onChange({
        leftField,
        right: this.props.join.right
      });
    });
    (0, _defineProperty2.default)(this, "_onRightSourceChange", indexPatternId => {
      this.setState({
        rightFields: [],
        loadError: undefined
      });
      this._loadRightFields(indexPatternId);
      const {
        term,
        ...restOfRight
      } = this.props.join.right;
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...restOfRight,
          indexPatternId,
          type: _constants.SOURCE_TYPES.ES_TERM_SOURCE
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onRightFieldChange", term => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          term
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onRightSizeChange", size => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          size
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onMetricsChange", metrics => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          metrics
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onWhereQueryChange", whereQuery => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          whereQuery
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalQueryChange", applyGlobalQuery => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          applyGlobalQuery
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalTimeChange", applyGlobalTime => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          applyGlobalTime
        }
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadRightFields(_lodash.default.get(this.props.join, 'right.indexPatternId'));
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadRightFields(indexPatternId) {
    if (!indexPatternId) {
      return;
    }
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(indexPatternId)
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }
    this.setState({
      rightFields: indexPattern.fields.filter(field => !_public.indexPatterns.isNestedField(field)),
      indexPattern
    });
  }
  render() {
    const {
      join,
      onRemove,
      leftFields,
      leftSourceName
    } = this.props;
    const {
      rightFields,
      indexPattern
    } = this.state;
    const right = _lodash.default.get(join, 'right', {});
    const rightSourceName = indexPattern ? indexPattern.getName() : right.indexPatternId;
    const isJoinConfigComplete = join.leftField && right.indexPatternId && right.term;
    let metricsExpression;
    let globalFilterCheckbox;
    let globalTimeCheckbox;
    if (isJoinConfigComplete) {
      metricsExpression = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_metrics_expression.MetricsExpression, {
        metrics: right.metrics ? right.metrics : [{
          type: _constants.AGG_TYPE.COUNT
        }],
        rightFields: rightFields,
        onChange: this._onMetricsChange
      }));
      globalFilterCheckbox = /*#__PURE__*/_react.default.createElement(_global_filter_checkbox.GlobalFilterCheckbox, {
        applyGlobalQuery: typeof right.applyGlobalQuery === 'undefined' ? true : right.applyGlobalQuery,
        setApplyGlobalQuery: this._onApplyGlobalQueryChange,
        label: _i18n.i18n.translate('xpack.maps.layerPanel.join.applyGlobalQueryCheckboxLabel', {
          defaultMessage: `Apply global search to join`
        })
      });
      if (this.state.indexPattern && this.state.indexPattern.timeFieldName) {
        globalTimeCheckbox = /*#__PURE__*/_react.default.createElement(_global_time_checkbox.GlobalTimeCheckbox, {
          applyGlobalTime: typeof right.applyGlobalTime === 'undefined' ? true : right.applyGlobalTime,
          setApplyGlobalTime: this._onApplyGlobalTimeChange,
          label: _i18n.i18n.translate('xpack.maps.layerPanel.join.applyGlobalTimeCheckboxLabel', {
            defaultMessage: `Apply global time to join`
          })
        });
      }
    }
    let whereExpression;
    if (indexPattern && isJoinConfigComplete) {
      whereExpression = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_where_expression.WhereExpression, {
        indexPattern: indexPattern,
        whereQuery: right.whereQuery,
        onChange: this._onWhereQueryChange
      }));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapJoinItem"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: "mapJoinItem__inner",
      responsive: false,
      wrap: true,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_join_expression.JoinExpression, {
      leftSourceName: leftSourceName,
      leftValue: join.leftField,
      leftFields: leftFields,
      onLeftFieldChange: this._onLeftFieldChange,
      rightSourceIndexPatternId: right.indexPatternId,
      rightSourceName: rightSourceName,
      onRightSourceChange: this._onRightSourceChange,
      rightValue: right.term,
      rightSize: right.size,
      rightFields: rightFields,
      onRightFieldChange: this._onRightFieldChange,
      onRightSizeChange: this._onRightSizeChange
    })), metricsExpression, whereExpression), globalFilterCheckbox, globalTimeCheckbox, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "mapJoinItem__delete",
      iconType: "trash",
      color: "danger",
      "aria-label": _i18n.i18n.translate('xpack.maps.layerPanel.join.deleteJoinAriaLabel', {
        defaultMessage: 'Delete join'
      }),
      title: _i18n.i18n.translate('xpack.maps.layerPanel.join.deleteJoinTitle', {
        defaultMessage: 'Delete join'
      }),
      onClick: onRemove
    }));
  }
}
exports.Join = Join;