"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinEditor = JoinEditor;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _join = require("./resources/join");
var _join_documentation_popover = require("./resources/join_documentation_popover");
var _constants = require("../../../../common/constants");
var _add_join_button = require("./add_join_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JoinEditor({
  joins,
  layer,
  onChange,
  leftJoinFields,
  layerDisplayName
}) {
  const renderJoins = () => {
    return joins.map((joinDescriptor, index) => {
      const handleOnChange = updatedDescriptor => {
        onChange(layer, [...joins.slice(0, index), updatedDescriptor, ...joins.slice(index + 1)]);
      };
      const handleOnRemove = () => {
        onChange(layer, [...joins.slice(0, index), ...joins.slice(index + 1)]);
      };
      if (joinDescriptor.right.type === _constants.SOURCE_TYPES.TABLE_SOURCE) {
        throw new Error('PEBKAC - Table sources cannot be edited in the UX and should only be used in MapEmbeddable');
      } else {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: index
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_join.Join, {
          join: joinDescriptor,
          layer: layer,
          onChange: handleOnChange,
          onRemove: handleOnRemove,
          leftFields: leftJoinFields,
          leftSourceName: layerDisplayName
        }));
      }
    });
  };
  const addJoin = () => {
    onChange(layer, [...joins, {
      right: {
        id: (0, _uuid.v4)(),
        applyGlobalQuery: true,
        applyGlobalTime: true
      }
    }]);
  };
  function renderContent() {
    const disabledReason = layer.getJoinsDisabledReason();
    return disabledReason ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, disabledReason) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, renderJoins(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement(_add_join_button.AddJoinButton, {
      addJoin: addJoin,
      isLayerSourceMvt: layer.getSource().isMvt(),
      numJoins: joins.length
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerPanel.joinEditor.termJoinsTitle",
    defaultMessage: "Term joins"
  }), ' ', /*#__PURE__*/_react.default.createElement(_join_documentation_popover.JoinDocumentationPopover, null))), renderContent());
}