"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinEditor = void 0;
var _reactRedux = require("react-redux");
var _join_editor = require("./join_editor");
var _map_selectors = require("../../../selectors/map_selectors");
var _actions = require("../../../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    joins: (0, _map_selectors.getSelectedLayerJoinDescriptors)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    onChange: (layer, joins) => {
      dispatch((0, _actions.setJoinsForLayer)(layer, joins));
    }
  };
}
const connectedJoinEditor = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_join_editor.JoinEditor);
exports.JoinEditor = connectedJoinEditor;