"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddJoinButton = AddJoinButton;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_LABEL = _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.addJoinButton.label', {
  defaultMessage: 'Add join'
});
function AddJoinButton({
  addJoin,
  isLayerSourceMvt,
  numJoins
}) {
  const isDisabled = isLayerSourceMvt && numJoins >= 1;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: addJoin,
    size: "xs",
    iconType: "plusInCircleFilled",
    "aria-label": BUTTON_LABEL,
    isDisabled: isDisabled
  }, BUTTON_LABEL);
  return isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.addJoinButton.mvtSingleJoinMsg', {
      defaultMessage: `Vector tiles support one term join. To add multiple joins, select 'Limit results' in 'Scaling'.`
    })
  }, button) : button;
}