"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutFooter = void 0;
var _reactRedux = require("react-redux");
var _flyout_footer = require("./flyout_footer");
var _ui = require("../../../reducers/ui");
var _map_selectors = require("../../../selectors/map_selectors");
var _actions = require("../../../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    hasStateChanged: (0, _map_selectors.hasDirtyState)(state),
    selectedLayer: (0, _map_selectors.getSelectedLayer)(state)
  };
}
const mapDispatchToProps = dispatch => {
  return {
    cancelLayerPanel: () => {
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
      dispatch((0, _actions.setSelectedLayer)(null));
    },
    saveLayerEdits: () => {
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
      dispatch((0, _actions.removeTrackedLayerStateForSelectedLayer)());
      dispatch((0, _actions.setSelectedLayer)(null));
    },
    removeLayer: () => {
      dispatch((0, _actions.removeSelectedLayer)());
    }
  };
};
const connectedFlyoutFooter = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_flyout_footer.FlyoutFooter);
exports.FlyoutFooter = connectedFlyoutFooter;