"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditLayerPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _filter_editor = require("./filter_editor");
var _join_editor = require("./join_editor");
var _flyout_footer = require("./flyout_footer");
var _layer_settings = require("./layer_settings");
var _style_settings = require("./style_settings");
var _kibana_services = require("../../kibana_services");
var _vector_layer = require("../../classes/layers/vector_layer");
var _layer_group = require("../../classes/layers/layer_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public2.Storage(window.localStorage);
class EditLayerPanel extends _react.Component {
  constructor(..._args) {
    super(..._args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      displayName: '',
      immutableSourceProps: [],
      leftJoinFields: [],
      supportsFitToBounds: false
    });
    (0, _defineProperty2.default)(this, "_loadSupportsFitToBounds", async () => {
      if (!this.props.selectedLayer) {
        return;
      }
      const supportsFitToBounds = await this.props.selectedLayer.supportsFitToBounds();
      if (this._isMounted) {
        this.setState({
          supportsFitToBounds
        });
      }
    });
    (0, _defineProperty2.default)(this, "_loadDisplayName", async () => {
      if (!this.props.selectedLayer) {
        return;
      }
      const displayName = await this.props.selectedLayer.getDisplayName();
      if (this._isMounted) {
        this.setState({
          displayName
        });
      }
    });
    (0, _defineProperty2.default)(this, "_loadImmutableSourceProperties", async () => {
      if (!this.props.selectedLayer || (0, _layer_group.isLayerGroup)(this.props.selectedLayer)) {
        return;
      }
      const immutableSourceProps = await this.props.selectedLayer.getImmutableSourceProperties();
      if (this._isMounted) {
        this.setState({
          immutableSourceProps
        });
      }
    });
    (0, _defineProperty2.default)(this, "_onSourceChange", (...args) => {
      return this.props.updateSourceProps(this.props.selectedLayer.getId(), args);
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadDisplayName();
    this._loadImmutableSourceProperties();
    this._loadLeftJoinFields();
    this._loadSupportsFitToBounds();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLeftJoinFields() {
    if (!this.props.selectedLayer || !(0, _vector_layer.isVectorLayer)(this.props.selectedLayer)) {
      return;
    }
    const vectorLayer = this.props.selectedLayer;
    if (!vectorLayer.showJoinEditor() || vectorLayer.getLeftJoinFields === undefined) {
      return;
    }
    let leftJoinFields = [];
    try {
      const leftFieldsInstances = await this.props.selectedLayer.getLeftJoinFields();
      const leftFieldPromises = leftFieldsInstances.map(async field => {
        return {
          name: field.getName(),
          label: await field.getLabel()
        };
      });
      leftJoinFields = await Promise.all(leftFieldPromises);
    } catch (error) {
      // ignore exceptions getting fields, will bubble up in layer errors panel
    }
    if (this._isMounted) {
      this.setState({
        leftJoinFields
      });
    }
  }
  _renderLayerErrors() {
    if (!this.props.selectedLayer || !this.props.selectedLayer.hasErrors()) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      title: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.unableToLoadTitle', {
        defaultMessage: 'Unable to load layer'
      })
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "layerErrorMessage"
    }, this.props.selectedLayer.getErrors())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  _renderFilterSection() {
    if (!this.props.selectedLayer || (0, _layer_group.isLayerGroup)(this.props.selectedLayer) || !this.props.selectedLayer.supportsElasticsearchFilters()) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_filter_editor.FilterEditor, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  _renderJoinSection() {
    if (!this.props.selectedLayer || !(0, _vector_layer.isVectorLayer)(this.props.selectedLayer)) {
      return;
    }
    const vectorLayer = this.props.selectedLayer;
    if (!vectorLayer.showJoinEditor()) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_join_editor.JoinEditor, {
      layer: vectorLayer,
      leftJoinFields: this.state.leftJoinFields,
      layerDisplayName: this.state.displayName
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  _renderSourceDetails() {
    return !this.props.selectedLayer || (0, _layer_group.isLayerGroup)(this.props.selectedLayer) ? null : /*#__PURE__*/_react.default.createElement("div", {
      className: "mapLayerPanel__sourceDetails"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "accordion1",
      buttonContent: _i18n.i18n.translate('xpack.maps.layerPanel.sourceDetailsLabel', {
        defaultMessage: 'Source details'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), this.state.immutableSourceProps.map(({
      label,
      value,
      link
    }) => {
      function renderValue() {
        if (link) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: link,
            target: "_blank"
          }, value);
        }
        return /*#__PURE__*/_react.default.createElement("span", null, value);
      }
      return /*#__PURE__*/_react.default.createElement("p", {
        key: label,
        className: "mapLayerPanel__sourceDetail"
      }, /*#__PURE__*/_react.default.createElement("strong", null, label), " ", renderValue());
    }))));
  }
  _renderSourceEditor() {
    if (!this.props.selectedLayer) {
      return null;
    }
    const descriptor = this.props.selectedLayer.getDescriptor();
    const numberOfJoins = descriptor.joins ? descriptor.joins.length : 0;
    return (0, _layer_group.isLayerGroup)(this.props.selectedLayer) ? null : this.props.selectedLayer.renderSourceSettingsEditor({
      currentLayerType: this.props.selectedLayer.getType(),
      numberOfJoins,
      onChange: this._onSourceChange,
      onStyleDescriptorChange: this.props.updateStyleDescriptor,
      style: this.props.selectedLayer.getStyleForEditing()
    });
  }
  _renderStyleEditor() {
    return !this.props.selectedLayer || (0, _layer_group.isLayerGroup)(this.props.selectedLayer) ? null : /*#__PURE__*/_react.default.createElement(_style_settings.StyleSettings, null);
  }
  render() {
    if (!this.props.selectedLayer) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        appName: 'maps',
        storage: localStorage,
        data: (0, _kibana_services.getData)(),
        ...(0, _kibana_services.getCore)()
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      className: "mapLayerPanel__header"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: this.props.selectedLayer.getLayerTypeIconName()
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, this.state.displayName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), this._renderSourceDetails()), /*#__PURE__*/_react.default.createElement("div", {
      className: "mapLayerPanel__body"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapLayerPanel__bodyOverflow"
    }, this._renderLayerErrors(), /*#__PURE__*/_react.default.createElement(_layer_settings.LayerSettings, {
      layer: this.props.selectedLayer,
      supportsFitToBounds: this.state.supportsFitToBounds
    }), this._renderSourceEditor(), this._renderFilterSection(), this._renderJoinSection(), this._renderStyleEditor())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      className: "mapLayerPanel__footer"
    }, /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, null))));
  }
}
exports.EditLayerPanel = EditLayerPanel;