"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleFieldSelect = SingleFieldSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fieldsToOptions(fields, isFieldDisabled) {
  if (!fields) {
    return [];
  }
  return fields.map(field => {
    const option = {
      value: field,
      label: field.displayName ? field.displayName : field.name
    };
    if (isFieldDisabled && isFieldDisabled(field)) {
      option.disabled = true;
    }
    return option;
  }).sort((a, b) => {
    return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
  });
}
function SingleFieldSelect({
  fields,
  getFieldDisabledReason,
  isFieldDisabled,
  onChange,
  value,
  ...rest
}) {
  function renderOption(option, searchValue, contentClassName) {
    const content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: contentClassName,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: null
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: option.value.type,
      fill: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)));
    const disabledReason = option.disabled && getFieldDisabledReason ? getFieldDisabledReason(option.value) : null;
    return disabledReason ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: disabledReason
    }, content) : content;
  }
  const onSelection = selectedOptions => {
    onChange(_lodash.default.get(selectedOptions, '0.value.name'));
  };
  const selectedOptions = [];
  if (value && fields) {
    const selectedField = fields.find(field => {
      return field.name === value;
    });
    if (selectedField) {
      selectedOptions.push({
        value: selectedField,
        label: selectedField.displayName ? selectedField.displayName : selectedField.name
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    singleSelection: true,
    options: fieldsToOptions(fields, isFieldDisabled),
    selectedOptions: selectedOptions,
    onChange: onSelection,
    isDisabled: !fields || fields.length === 0,
    renderOption: renderOption
  }, rest));
}