"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoIndexPatternSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../kibana_services");
var _i18n_getters = require("../../common/i18n_getters");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GeoIndexPatternSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      doesIndexPatternHaveGeoField: false,
      noIndexPatternsExist: false
    });
    (0, _defineProperty2.default)(this, "_onIndexPatternSelect", async indexPatternId => {
      if (!indexPatternId || indexPatternId.length === 0) {
        return;
      }
      let indexPattern;
      try {
        indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
      } catch (err) {
        return;
      }

      // method may be called again before 'get' returns
      // ignore response when fetched index pattern does not match active index pattern
      if (this._isMounted && indexPattern.id === indexPatternId) {
        this.setState({
          doesIndexPatternHaveGeoField: indexPattern.fields.some(field => {
            var _this$props;
            return (_this$props = this.props) !== null && _this$props !== void 0 && _this$props.isGeoPointsOnly ? _constants.ES_GEO_FIELD_TYPE.GEO_POINT === field.type : _constants.ES_GEO_FIELD_TYPES.includes(field.type);
          })
        });
        this.props.onChange(indexPattern);
      }
    });
    (0, _defineProperty2.default)(this, "_onNoIndexPatterns", () => {
      this.setState({
        noIndexPatternsExist: true
      });
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
  }
  _renderNoIndexPatternWarning() {
    if (!this.state.noIndexPatternsExist) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.maps.noIndexPattern.messageTitle', {
        defaultMessage: `Couldn't find any data views`
      }),
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisPrefixDescription",
      defaultMessage: "You'll need to "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend(`/app/management/kibana/dataViews`)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisLinkTextDescription",
      defaultMessage: "Create a data view."
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.hintDescription",
      defaultMessage: "Don't have any data? "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend('/app/home#/tutorial_directory/sampleData')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.getStartedLinkText",
      defaultMessage: "Get started with some sample data sets."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  render() {
    const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
    const isIndexPatternInvalid = !!this.props.value && !this.state.doesIndexPatternHaveGeoField;
    const error = isIndexPatternInvalid ? _i18n.i18n.translate('xpack.maps.noGeoFieldInIndexPattern.message', {
      defaultMessage: 'Data view does not contain any geospatial fields'
    }) : '';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderNoIndexPatternWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      isInvalid: isIndexPatternInvalid,
      error: error
    }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
      isInvalid: isIndexPatternInvalid,
      isDisabled: this.state.noIndexPatternsExist,
      indexPatternId: this.props.value ? this.props.value : '',
      onChange: this._onIndexPatternSelect,
      placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
      onNoIndexPatterns: this._onNoIndexPatterns,
      isClearable: false,
      "data-test-subj": "mapGeoIndexPatternSelect"
    })));
  }
}
exports.GeoIndexPatternSelect = GeoIndexPatternSelect;