"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForceRefreshCheckbox = ForceRefreshCheckbox;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ForceRefreshCheckbox({
  applyForceRefresh,
  setApplyForceRefresh
}) {
  const onChange = event => {
    setApplyForceRefresh(event.target.checked);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.maps.filterEditor.applyForceRefreshTooltip', {
      defaultMessage: `When enabled, layer re-fetches data when automatic refresh fires and when "Refresh" is clicked.`
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.filterEditor.applyForceRefreshLabel', {
      defaultMessage: `Apply global refresh to layer data`
    }),
    checked: applyForceRefresh,
    onChange: onChange,
    "data-test-subj": "mapLayerPanelRespondToForceRefreshCheckbox",
    compressed: true
  })));
}