"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinTooltipProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _join_key_label = require("./join_key_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JoinTooltipProperty {
  constructor(tooltipProperty, innerJoins) {
    (0, _defineProperty2.default)(this, "_tooltipProperty", void 0);
    (0, _defineProperty2.default)(this, "_innerJoins", void 0);
    this._tooltipProperty = tooltipProperty;
    this._innerJoins = innerJoins;
  }
  isFilterable() {
    return true;
  }
  getPropertyKey() {
    return this._tooltipProperty.getPropertyKey();
  }
  getPropertyName() {
    return /*#__PURE__*/_react.default.createElement(_join_key_label.JoinKeyLabel, {
      leftFieldName: this._tooltipProperty.getPropertyName(),
      innerJoins: this._innerJoins
    });
  }
  getRawValue() {
    return this._tooltipProperty.getRawValue();
  }
  getHtmlDisplayValue() {
    return this._tooltipProperty.getHtmlDisplayValue();
  }
  async getESFilters() {
    const esFilters = [];

    // only create filters for right sources.
    // do not create filters for left source.
    for (let i = 0; i < this._innerJoins.length; i++) {
      const rightSource = this._innerJoins[i].getRightJoinSource();
      const termField = rightSource.getTermField();
      try {
        const esTooltipProperty = await termField.createTooltipProperty(this._tooltipProperty.getRawValue());
        if (esTooltipProperty) {
          const filters = await esTooltipProperty.getESFilters();
          esFilters.push(...filters);
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.error('Cannot create joined filter', e);
      }
    }
    return esFilters;
  }
}
exports.JoinTooltipProperty = JoinTooltipProperty;