"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractStyleProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_vector_style_label = require("../components/get_vector_style_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

// @ts-ignore

class AbstractStyleProperty {
  constructor(options, styleName) {
    (0, _defineProperty2.default)(this, "_options", void 0);
    (0, _defineProperty2.default)(this, "_styleName", void 0);
    this._options = options;
    this._styleName = styleName;
  }
  isDynamic() {
    return false;
  }

  /**
   * Is the style fully defined and usable? (e.g. for rendering, in legend UX, ...)
   * Why? during editing, partially-completed descriptors may be added to the layer-descriptor
   * e.g. dynamic-fields can have an incomplete state when the field is not yet selected from the drop-down
   * @returns {boolean}
   */
  isComplete() {
    return true;
  }
  formatField(value) {
    if (typeof value === 'undefined' || value === null) {
      return '';
    } else if (typeof value === 'boolean') {
      return value.toString();
    } else if (Array.isArray(value)) {
      return value.join(', ');
    } else {
      return value;
    }
  }
  getStyleName() {
    return this._styleName;
  }
  getOptions() {
    return this._options;
  }
  renderLegendDetailRow({
    isPointsOnly,
    isLinesOnly
  }) {
    return null;
  }
  renderDataMappingPopover(onChange) {
    return null;
  }
  getDisplayStyleName() {
    return (0, _get_vector_style_label.getVectorStyleLabel)(this.getStyleName());
  }
}
exports.AbstractStyleProperty = AbstractStyleProperty;