"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicIconForm = DynamicIconForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_select = require("../field_select");
var _icon_map_select = require("./icon_map_select");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DynamicIconForm({
  fields,
  onDynamicStyleChange,
  onCustomIconsChange,
  customIcons,
  staticDynamicSelect,
  styleProperty
}) {
  const styleOptions = styleProperty.getOptions();
  const onFieldChange = ({
    field
  }) => {
    if (!field) {
      return;
    }
    const {
      name,
      origin
    } = field;
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      field: {
        name,
        origin
      }
    });
  };
  const onIconMapChange = newOptions => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      ...newOptions
    });
  };
  function renderIconMapSelect() {
    const field = styleProperty.getField();
    if (!field) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_icon_map_select.IconMapSelect, (0, _extends2.default)({}, styleOptions, {
      styleProperty: styleProperty,
      customIcons: customIcons,
      onChange: onIconMapChange,
      onCustomIconsChange: onCustomIconsChange,
      isCustomOnly: !field.supportsFieldMetaFromLocalData() && !field.supportsFieldMetaFromEs()
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    styleName: styleProperty.getStyleName(),
    fields: fields,
    selectedFieldName: _lodash.default.get(styleOptions, 'field.name'),
    onChange: onFieldChange,
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), renderIconMapSelect());
}