"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticSizeShape = exports.staticOrientationShape = exports.staticColorShape = exports.dynamicSizeShape = exports.dynamicOrientationShape = exports.dynamicColorShape = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _field_select = require("./field_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticColorShape = _propTypes.default.shape({
  color: _propTypes.default.string.isRequired
});
exports.staticColorShape = staticColorShape;
const dynamicColorShape = _propTypes.default.shape({
  color: _propTypes.default.string,
  field: _field_select.fieldShape,
  customColorRamp: _propTypes.default.array,
  useCustomColorRamp: _propTypes.default.bool
});
exports.dynamicColorShape = dynamicColorShape;
const staticOrientationShape = _propTypes.default.shape({
  orientation: _propTypes.default.number.isRequired
});
exports.staticOrientationShape = staticOrientationShape;
const dynamicOrientationShape = _propTypes.default.shape({
  field: _field_select.fieldShape
});
exports.dynamicOrientationShape = dynamicOrientationShape;
const staticSizeShape = _propTypes.default.shape({
  size: _propTypes.default.number.isRequired
});
exports.staticSizeShape = staticSizeShape;
const dynamicSizeShape = _propTypes.default.shape({
  minSize: _propTypes.default.number.isRequired,
  maxSize: _propTypes.default.number.isRequired,
  field: _field_select.fieldShape
});
exports.dynamicSizeShape = dynamicSizeShape;