"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _color_gradient = require("./color_gradient");
var _ranged_style_legend_row = require("../../../components/ranged_style_legend_row");
var _heatmap_constants = require("../heatmap_constants");
var _mask_legend = require("../../../vector/components/legend/mask_legend");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class HeatmapLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: ''
    });
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const label = await this.props.field.getLabel();
    if (this._isMounted && this.state.label !== label) {
      this.setState({
        label
      });
    }
  }
  render() {
    const metricLegend = /*#__PURE__*/_react.default.createElement(_ranged_style_legend_row.RangedStyleLegendRow, {
      header: /*#__PURE__*/_react.default.createElement(_color_gradient.ColorGradient, {
        colorPaletteId: this.props.colorRampName
      }),
      minLabel: _i18n.i18n.translate('xpack.maps.heatmapLegend.coldLabel', {
        defaultMessage: 'cold'
      }),
      maxLabel: _i18n.i18n.translate('xpack.maps.heatmapLegend.hotLabel', {
        defaultMessage: 'hot'
      }),
      propertyLabel: _heatmap_constants.HEATMAP_COLOR_RAMP_LABEL,
      fieldLabel: this.state.label,
      invert: false
    });
    let maskLegend;
    if ('getMask' in this.props.field) {
      const mask = this.props.field.getMask();
      if (mask) {
        maskLegend = /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
          esAggField: this.props.field,
          operator: mask.operator,
          value: mask.value
        });
      }
    }
    return maskLegend ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, maskLegend, metricLegend) : metricLegend;
  }
}
exports.HeatmapLegend = HeatmapLegend;