"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapStyleEditor = HeatmapStyleEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _color_palettes = require("../../color_palettes");
var _heatmap_constants = require("./heatmap_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeatmapStyleEditor({
  colorRampName,
  onHeatmapColorChange
}) {
  const onColorRampChange = selectedPaletteId => {
    onHeatmapColorChange({
      colorRampName: selectedPaletteId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _heatmap_constants.HEATMAP_COLOR_RAMP_LABEL,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    palettes: _color_palettes.NUMERICAL_COLOR_PALETTES,
    onChange: onColorRampChange,
    valueOfSelected: colorRampName,
    compressed: true
  }));
}