"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WMSCreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _wms_client = require("./wms_client");
var _lodash = _interopRequireDefault(require("lodash"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAYERS_LABEL = _i18n.i18n.translate('xpack.maps.source.wms.layersLabel', {
  defaultMessage: 'Layers'
});
const STYLES_LABEL = _i18n.i18n.translate('xpack.maps.source.wms.stylesLabel', {
  defaultMessage: 'Styles'
});
class WMSCreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      serviceUrl: '',
      layers: '',
      styles: '',
      isLoadingCapabilities: false,
      getCapabilitiesError: null,
      hasAttemptedToLoadCapabilities: false,
      layerOptions: [],
      styleOptions: [],
      selectedLayerOptions: [],
      selectedStyleOptions: []
    });
    (0, _defineProperty2.default)(this, "_previewIfPossible", _lodash.default.debounce(() => {
      const {
        serviceUrl,
        layers,
        styles
      } = this.state;
      const sourceConfig = serviceUrl && layers ? {
        serviceUrl,
        layers,
        styles
      } : null;
      this.props.onSourceConfigChange(sourceConfig);
    }, 2000));
    (0, _defineProperty2.default)(this, "_loadCapabilities", async () => {
      if (!this.state.serviceUrl) {
        return;
      }
      this.setState({
        hasAttemptedToLoadCapabilities: true,
        isLoadingCapabilities: true,
        getCapabilitiesError: null
      });
      const wmsClient = new _wms_client.WmsClient({
        serviceUrl: this.state.serviceUrl
      });
      let capabilities;
      try {
        capabilities = await wmsClient.getCapabilities();
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            isLoadingCapabilities: false,
            getCapabilitiesError: error.message
          });
        }
        return;
      }
      if (!this._isMounted) {
        return;
      }
      this.setState({
        isLoadingCapabilities: false,
        layerOptions: capabilities.layers,
        styleOptions: capabilities.styles
      });
    });
    (0, _defineProperty2.default)(this, "_handleServiceUrlChange", e => {
      this.setState({
        serviceUrl: e.target.value,
        hasAttemptedToLoadCapabilities: false,
        layerOptions: [],
        styleOptions: [],
        selectedLayerOptions: [],
        selectedStyleOptions: [],
        layers: '',
        styles: ''
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleLayersChange", e => {
      this.setState({
        layers: e.target.value
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleLayerOptionsChange", selectedOptions => {
      this.setState({
        selectedLayerOptions: selectedOptions,
        layers: selectedOptions.map(selectedOption => {
          return selectedOption.value;
        }).join(',')
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleStylesChange", e => {
      this.setState({
        styles: e.target.value
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleStyleOptionsChange", selectedOptions => {
      this.setState({
        selectedStyleOptions: selectedOptions,
        styles: selectedOptions.map(selectedOption => {
          return selectedOption.value;
        }).join(',')
      }, this._previewIfPossible);
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  _renderLayerAndStyleInputs() {
    if (!this.state.hasAttemptedToLoadCapabilities || this.state.isLoadingCapabilities) {
      return null;
    }
    if (this.state.getCapabilitiesError || this.state.layerOptions.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.maps.source.wms.getCapabilitiesErrorCalloutTitle', {
          defaultMessage: 'Unable to load service metadata'
        }),
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement("p", null, this.state.getCapabilitiesError)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: LAYERS_LABEL,
        helpText: _i18n.i18n.translate('xpack.maps.source.wms.layersHelpText', {
          defaultMessage: 'Use comma separated list of layer names'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this._handleLayersChange
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: STYLES_LABEL,
        helpText: _i18n.i18n.translate('xpack.maps.source.wms.stylesHelpText', {
          defaultMessage: 'Use comma separated list of style names'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this._handleStylesChange
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: LAYERS_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: this.state.layerOptions,
      selectedOptions: this.state.selectedLayerOptions,
      onChange: this._handleLayerOptionsChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: STYLES_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: this.state.styleOptions,
      selectedOptions: this.state.selectedStyleOptions,
      onChange: this._handleStyleOptionsChange
    })));
  }
  _renderGetCapabilitiesButton() {
    if (!this.state.isLoadingCapabilities && this.state.hasAttemptedToLoadCapabilities) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this._loadCapabilities,
      isDisabled: !this.state.serviceUrl,
      isLoading: this.state.isLoadingCapabilities
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.wms.getCapabilitiesButtonText",
      defaultMessage: "Load capabilities"
    })));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.wms.urlLabel', {
        defaultMessage: 'Url'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.serviceUrl,
      onChange: this._handleServiceUrlChange
    })), this._renderGetCapabilitiesButton(), this._renderLayerAndStyleInputs());
  }
}
exports.WMSCreateSourceEditor = WMSCreateSourceEditor;