"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _copy_persistent_state = require("../../reducers/copy_persistent_state");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

class AbstractSource {
  constructor(descriptor) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = descriptor;
  }
  cloneDescriptor() {
    return (0, _copy_persistent_state.copyPersistentState)(this._descriptor);
  }
  async supportsFitToBounds() {
    return false;
  }

  /**
   * return list of immutable source properties.
   * Immutable source properties are properties that can not be edited by the user.
   */
  async getImmutableProperties() {
    return [];
  }
  getType() {
    return this._descriptor.type;
  }
  async getDisplayName() {
    return '';
  }
  getAttributionProvider() {
    return null;
  }
  isFieldAware() {
    return false;
  }
  isQueryAware() {
    return false;
  }
  getFieldNames() {
    return [];
  }
  renderSourceSettingsEditor(sourceEditorArgs) {
    return null;
  }
  getApplyGlobalQuery() {
    return false;
  }
  getApplyGlobalTime() {
    return false;
  }
  getApplyForceRefresh() {
    return false;
  }
  getIndexPatternIds() {
    return [];
  }
  getQueryableIndexPatternIds() {
    return [];
  }
  isESSource() {
    return false;
  }

  // Returns function used to format value
  async createFieldFormatter(field) {
    return null;
  }
  async getValueSuggestions(field, query) {
    return [];
  }
  async isTimeAware() {
    return false;
  }
  isFilterByMapBounds() {
    return false;
  }
  getMinZoom() {
    return _constants.MIN_ZOOM;
  }
  getMaxZoom() {
    return _constants.MAX_ZOOM;
  }
  async getLicensedFeatures() {
    return [];
  }
  getUpdateDueToTimeslice(prevMeta, timeslice) {
    return true;
  }
}
exports.AbstractSource = AbstractSource;